/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.util.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Hashtable;
import javax.security.auth.x500.X500Principal;
import org.apache.geronimo.util.asn1.ASN1InputStream;
import org.apache.geronimo.util.asn1.ASN1Sequence;
import org.apache.geronimo.util.asn1.ASN1Set;
import org.apache.geronimo.util.asn1.DERBitString;
import org.apache.geronimo.util.asn1.DERObjectIdentifier;
import org.apache.geronimo.util.asn1.DEROutputStream;
import org.apache.geronimo.util.asn1.pkcs.CertificationRequest;
import org.apache.geronimo.util.asn1.pkcs.CertificationRequestInfo;
import org.apache.geronimo.util.asn1.pkcs.PKCSObjectIdentifiers;
import org.apache.geronimo.util.asn1.x509.AlgorithmIdentifier;
import org.apache.geronimo.util.asn1.x509.SubjectPublicKeyInfo;
import org.apache.geronimo.util.asn1.x509.X509Name;
import org.apache.geronimo.util.asn1.x9.X9ObjectIdentifiers;
import org.apache.geronimo.util.jce.X509Principal;

public class PKCS10CertificationRequest
extends CertificationRequest {
    private static Hashtable algorithms = new Hashtable();
    private static Hashtable oids = new Hashtable();

    private static ASN1Sequence toDERSequence(byte[] bytes) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ASN1InputStream dIn = new ASN1InputStream(bIn);
            return (ASN1Sequence)dIn.readObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("badly encoded request", e);
        }
    }

    public PKCS10CertificationRequest(byte[] bytes) {
        super(PKCS10CertificationRequest.toDERSequence(bytes));
    }

    public PKCS10CertificationRequest(ASN1Sequence sequence) {
        super(sequence);
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X509Name subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, subject, key, attributes, signingKey, null);
    }

    private static X509Name convertName(X500Principal name) {
        try {
            return new X509Principal(name.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't convert name", e);
        }
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X500Principal subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, PKCS10CertificationRequest.convertName(subject), key, attributes, signingKey, null);
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X500Principal subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, PKCS10CertificationRequest.convertName(subject), key, attributes, signingKey, provider);
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X509Name subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        DERObjectIdentifier sigOID = (DERObjectIdentifier)algorithms.get(signatureAlgorithm.toUpperCase());
        if (sigOID == null) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        this.sigAlgId = new AlgorithmIdentifier(sigOID, null);
        byte[] bytes = key.getEncoded();
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        ASN1InputStream dIn = new ASN1InputStream(bIn);
        try {
            this.reqInfo = new CertificationRequestInfo(subject, new SubjectPublicKeyInfo((ASN1Sequence)dIn.readObject()), attributes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't encode public key", e);
        }
        Signature sig = null;
        try {
            sig = provider == null ? Signature.getInstance(this.sigAlgId.getObjectId().getId()) : Signature.getInstance(this.sigAlgId.getObjectId().getId(), provider);
        }
        catch (NoSuchAlgorithmException e) {
            sig = provider == null ? Signature.getInstance(signatureAlgorithm) : Signature.getInstance(signatureAlgorithm, provider);
        }
        sig.initSign(signingKey);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.reqInfo);
            sig.update(bOut.toByteArray());
        }
        catch (Exception e) {
            throw new SecurityException("exception encoding TBS cert request - " + e.getMessage(), e);
        }
        this.sigBits = new DERBitString(sig.sign());
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        return this.getPublicKey(null);
    }

    public PublicKey getPublicKey(String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        SubjectPublicKeyInfo subjectPKInfo = this.reqInfo.getSubjectPublicKeyInfo();
        try {
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(new DERBitString(subjectPKInfo).getBytes());
            AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithmId();
            try {
                if (provider == null) {
                    return KeyFactory.getInstance(keyAlg.getObjectId().getId()).generatePublic(xspec);
                }
                return KeyFactory.getInstance(keyAlg.getObjectId().getId(), provider).generatePublic(xspec);
            }
            catch (NoSuchAlgorithmException e) {
                if (provider == null) {
                    return KeyFactory.getInstance("RSA").generatePublic(xspec);
                }
                return KeyFactory.getInstance("RSA", provider).generatePublic(xspec);
            }
        }
        catch (InvalidKeySpecException e) {
            throw (InvalidKeyException)new InvalidKeyException("error decoding public key").initCause(e);
        }
    }

    public boolean verify() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        return this.verify(null);
    }

    public boolean verify(String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature sig;
        block4: {
            sig = null;
            try {
                sig = provider == null ? Signature.getInstance(this.sigAlgId.getObjectId().getId()) : Signature.getInstance(this.sigAlgId.getObjectId().getId(), provider);
            }
            catch (NoSuchAlgorithmException e) {
                if (oids.get(this.sigAlgId.getObjectId().getId()) == null) break block4;
                String signatureAlgorithm = (String)oids.get(this.sigAlgId.getObjectId().getId());
                sig = provider == null ? Signature.getInstance(signatureAlgorithm) : Signature.getInstance(signatureAlgorithm, provider);
            }
        }
        sig.initVerify(this.getPublicKey(provider));
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.reqInfo);
            sig.update(bOut.toByteArray());
        }
        catch (Exception e) {
            throw (SecurityException)new SecurityException("exception encoding TBS cert request - " + e.getMessage()).initCause(e);
        }
        return sig.verify(this.sigBits.getBytes());
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return bOut.toByteArray();
    }

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD2WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.1"));
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("RSAWITHMD5", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA224WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA224WITHRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA256WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA256WITHRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA384WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA384WITHRSA", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA512WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA512WITHRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("RSAWITHSHA1", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("RIPEMD160WITHRSA", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("SHA1WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("ECDSAWITHSHA1", X9ObjectIdentifiers.ecdsa_with_SHA1);
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.5"), "SHA1WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.4"), "MD5WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.2"), "MD2WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.1"), "MD5WIDHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.10040.4.3"), "DSAWITHSHA1");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA1, "DSAWITHSHA1");
    }
}

