/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestHandlers {
    public static Logger log = LoggerFactory.getLogger(RequestHandlers.class);
    protected final SolrCore core;
    private final Map<String, SolrRequestHandler> handlers = new ConcurrentHashMap<String, SolrRequestHandler>();

    private static String normalize(String p) {
        if (p == null) {
            return "";
        }
        if (p.endsWith("/") && p.length() > 1) {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    public RequestHandlers(SolrCore core) {
        this.core = core;
    }

    public SolrRequestHandler get(String handlerName) {
        return this.handlers.get(RequestHandlers.normalize(handlerName));
    }

    public <T extends SolrRequestHandler> Map<String, T> getAll(Class<T> clazz) {
        HashMap<String, T> result = new HashMap<String, T>(7);
        for (Map.Entry<String, SolrRequestHandler> e : this.handlers.entrySet()) {
            if (!clazz.isInstance(e.getValue())) continue;
            result.put(e.getKey(), clazz.cast(e.getValue()));
        }
        return result;
    }

    public SolrRequestHandler register(String handlerName, SolrRequestHandler handler) {
        String norm = RequestHandlers.normalize(handlerName);
        if (handler == null) {
            return this.handlers.remove(norm);
        }
        SolrRequestHandler old = this.handlers.put(norm, handler);
        if (0 != norm.length() && handler instanceof SolrInfoMBean) {
            this.core.getInfoRegistry().put(handlerName, handler);
        }
        return old;
    }

    public Map<String, SolrRequestHandler> getRequestHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initHandlersFromConfig(SolrConfig config) {
        LinkedHashMap<PluginInfo, SolrRequestHandler> handlers = new LinkedHashMap<PluginInfo, SolrRequestHandler>();
        for (PluginInfo pluginInfo : config.getPluginInfos(SolrRequestHandler.class.getName())) {
            try {
                SolrRequestHandler requestHandler;
                String startup = pluginInfo.attributes.get("startup");
                if (startup != null) {
                    if (!"lazy".equals(startup)) throw new Exception("Unknown startup value: '" + startup + "' for: " + pluginInfo.className);
                    log.info("adding lazy requestHandler: " + pluginInfo.className);
                    requestHandler = new LazyRequestHandlerWrapper(this.core, pluginInfo.className, pluginInfo.initArgs);
                } else {
                    requestHandler = this.core.createRequestHandler(pluginInfo.className);
                }
                handlers.put(pluginInfo, requestHandler);
                SolrRequestHandler old = this.register(pluginInfo.name, requestHandler);
                if (old != null) {
                    log.warn("Multiple requestHandler registered to the same name: " + pluginInfo.name + " ignoring: " + old.getClass().getName());
                }
                if (pluginInfo.isDefault() && (old = this.register("", requestHandler)) != null) {
                    log.warn("Multiple default requestHandler registered ignoring: " + old.getClass().getName());
                }
                log.info("created " + pluginInfo.name + ": " + pluginInfo.className);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "RequestHandler init failure", (Throwable)ex);
            }
        }
        for (Map.Entry entry : handlers.entrySet()) {
            PluginInfo info = (PluginInfo)entry.getKey();
            SolrRequestHandler requestHandler = (SolrRequestHandler)entry.getValue();
            if (requestHandler instanceof PluginInfoInitialized) {
                ((PluginInfoInitialized)((Object)requestHandler)).init(info);
                continue;
            }
            requestHandler.init(info.initArgs);
        }
        if (this.get("") == null) {
            this.register("", this.get("/select"));
        }
        if (this.get("") == null) {
            this.register("", this.get("standard"));
        }
        if (this.get("") != null) return;
        log.warn("no default request handler is registered (either '/select' or 'standard')");
    }

    public static final class LazyRequestHandlerWrapper
    implements SolrRequestHandler {
        private final SolrCore core;
        private String _className;
        private NamedList _args;
        private SolrRequestHandler _handler;

        public LazyRequestHandlerWrapper(SolrCore core, String className, NamedList args) {
            this.core = core;
            this._className = className;
            this._args = args;
            this._handler = null;
        }

        @Override
        public void init(NamedList args) {
        }

        @Override
        public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
            SolrRequestHandler handler = this._handler;
            if (handler == null) {
                handler = this.getWrappedHandler();
            }
            handler.handleRequest(req, rsp);
        }

        public synchronized SolrRequestHandler getWrappedHandler() {
            if (this._handler == null) {
                try {
                    SolrRequestHandler handler = this.core.createRequestHandler(this._className);
                    handler.init(this._args);
                    if (handler instanceof SolrCoreAware) {
                        ((SolrCoreAware)((Object)handler)).inform(this.core);
                    }
                    this._handler = handler;
                }
                catch (Exception ex) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "lazy loading error", (Throwable)ex);
                }
            }
            return this._handler;
        }

        public String getHandlerClass() {
            return this._className;
        }

        @Override
        public String getName() {
            return "Lazy[" + this._className + "]";
        }

        @Override
        public String getDescription() {
            if (this._handler == null) {
                return this.getName();
            }
            return this._handler.getDescription();
        }

        @Override
        public String getVersion() {
            if (this._handler != null) {
                return this._handler.getVersion();
            }
            return null;
        }

        @Override
        public String getSource() {
            String rev = "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_7/solr/core/src/java/org/apache/solr/core/RequestHandlers.java $";
            if (this._handler != null) {
                rev = rev + "\n" + this._handler.getSource();
            }
            return rev;
        }

        @Override
        public URL[] getDocs() {
            if (this._handler == null) {
                return null;
            }
            return this._handler.getDocs();
        }

        @Override
        public SolrInfoMBean.Category getCategory() {
            return SolrInfoMBean.Category.QUERYHANDLER;
        }

        @Override
        public NamedList getStatistics() {
            if (this._handler != null) {
                return this._handler.getStatistics();
            }
            SimpleOrderedMap<String> lst = new SimpleOrderedMap<String>();
            lst.add("note", "not initialized yet");
            return lst;
        }
    }
}

