/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class PivotFacetHelper
extends SimpleFacets {
    protected int minMatch;

    public PivotFacetHelper(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        super(req, docs, params, rb);
        this.minMatch = params.getInt("facet.pivot.mincount", 1);
    }

    public SimpleOrderedMap<List<NamedList<Object>>> process(String[] pivots) throws IOException {
        if (!this.rb.doFacets || pivots == null) {
            return null;
        }
        SimpleOrderedMap<List<NamedList<Object>>> pivotResponse = new SimpleOrderedMap<List<NamedList<Object>>>();
        for (String pivot : pivots) {
            try {
                this.parseParams("facet.pivot", pivot);
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            pivot = this.facetValue;
            String[] fields = pivot.split(",");
            if (fields.length < 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Pivot Facet needs at least two fields: " + pivot);
            }
            String field = fields[0];
            String subField = fields[1];
            LinkedList<String> fnames = new LinkedList<String>();
            for (int i = fields.length - 1; i > 1; --i) {
                fnames.push(fields[i]);
            }
            NamedList<Integer> superFacets = this.getTermCounts(field);
            pivotResponse.add(this.key, this.doPivots(superFacets, field, subField, fnames, this.docs));
        }
        return pivotResponse;
    }

    protected List<NamedList<Object>> doPivots(NamedList<Integer> superFacets, String field, String subField, Deque<String> fnames, DocSet docs) throws IOException {
        SolrIndexSearcher searcher = this.rb.req.getSearcher();
        SchemaField sfield = searcher.getSchema().getField(field);
        FieldType ftype = sfield.getType();
        String nextField = fnames.poll();
        ArrayList<NamedList<Object>> values = new ArrayList<NamedList<Object>>(superFacets.size());
        for (Map.Entry<String, Integer> entry : superFacets) {
            if (entry.getValue() < this.minMatch) continue;
            String fieldValue = entry.getKey();
            BytesRef termval = null;
            SimpleOrderedMap<Object> pivot = new SimpleOrderedMap<Object>();
            pivot.add("field", field);
            if (null == fieldValue) {
                pivot.add("value", null);
            } else {
                termval = new BytesRef();
                ftype.readableToIndexed(fieldValue, termval);
                pivot.add("value", ftype.toObject(sfield, termval));
            }
            pivot.add("count", entry.getValue());
            if (subField == null) {
                values.add(pivot);
                continue;
            }
            DocSet subset = null;
            if (null == termval) {
                DocSet hasVal = searcher.getDocSet(new TermRangeQuery(field, null, null, false, false));
                subset = docs.andNot(hasVal);
            } else {
                TermQuery query = new TermQuery(new Term(field, termval));
                subset = searcher.getDocSet(query, docs);
            }
            this.docs = subset;
            NamedList<Integer> nl = this.getTermCounts(subField);
            if (nl.size() < this.minMatch) continue;
            pivot.add("pivot", this.doPivots(nl, subField, nextField, fnames, subset));
            values.add(pivot);
        }
        fnames.push(nextField);
        return values;
    }
}

