/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.SingleFunction;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.NamedParser;
import org.apache.solr.search.SyntaxError;

abstract class DoubleParser
extends NamedParser {
    public DoubleParser(String name) {
        super(name);
    }

    public abstract double func(int var1, FunctionValues var2);

    @Override
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        return new Function(fp.parseValueSource());
    }

    class Function
    extends SingleFunction {
        public Function(ValueSource source) {
            super(source);
        }

        @Override
        public String name() {
            return DoubleParser.this.name();
        }

        @Override
        public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
            final FunctionValues vals = this.source.getValues(context, readerContext);
            return new DoubleDocValues(this){

                @Override
                public double doubleVal(int doc) {
                    return DoubleParser.this.func(doc, vals);
                }

                @Override
                public String toString(int doc) {
                    return Function.this.name() + '(' + vals.toString(doc) + ')';
                }
            };
        }
    }
}

