/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.command.Pair;
import org.apache.solr.search.grouping.distributed.shardresultserializer.SearchGroupsResultTransformer;

public class SearchGroupShardResponseProcessor
implements ShardResponseProcessor {
    @Override
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        SortSpec ss = rb.getSortSpec();
        Sort groupSort = rb.getGroupingSpec().getGroupSort();
        String[] fields = rb.getGroupingSpec().getFields();
        HashMap commandSearchGroups = new HashMap();
        HashMap tempSearchGroupToShards = new HashMap();
        for (String field : fields) {
            commandSearchGroups.put(field, new ArrayList(shardRequest.responses.size()));
            tempSearchGroupToShards.put(field, new HashMap());
            if (rb.searchGroupToShards.containsKey(field)) continue;
            rb.searchGroupToShards.put(field, new HashMap());
        }
        SearchGroupsResultTransformer serializer = new SearchGroupsResultTransformer(rb.req.getSearcher());
        try {
            int maxElapsedTime = 0;
            int hitCountDuringFirstPhase = 0;
            SimpleOrderedMap shardInfo = null;
            if (rb.req.getParams().getBool("shards.info", false)) {
                shardInfo = new SimpleOrderedMap();
                rb.rsp.getValues().add("shards.info.firstPhase", shardInfo);
            }
            for (ShardResponse srsp : shardRequest.responses) {
                if (shardInfo != null) {
                    SimpleOrderedMap<Object> nl = new SimpleOrderedMap<Object>();
                    if (srsp.getException() != null) {
                        Throwable t = srsp.getException();
                        if (t instanceof SolrServerException) {
                            t = ((SolrServerException)t).getCause();
                        }
                        nl.add("error", t.toString());
                        StringWriter trace = new StringWriter();
                        t.printStackTrace(new PrintWriter(trace));
                        nl.add("trace", trace.toString());
                    } else {
                        nl.add("numFound", (Integer)srsp.getSolrResponse().getResponse().get("totalHitCount"));
                    }
                    if (srsp.getSolrResponse() != null) {
                        nl.add("time", srsp.getSolrResponse().getElapsedTime());
                    }
                    if (srsp.getShardAddress() != null) {
                        nl.add("shardAddress", srsp.getShardAddress());
                    }
                    shardInfo.add(srsp.getShard(), nl);
                }
                if (rb.req.getParams().getBool("shards.tolerant", false) && srsp.getException() != null) {
                    if (rb.rsp.getResponseHeader().get("partialResults") != null) continue;
                    rb.rsp.getResponseHeader().add("partialResults", Boolean.TRUE);
                    continue;
                }
                maxElapsedTime = (int)Math.max((long)maxElapsedTime, srsp.getSolrResponse().getElapsedTime());
                NamedList firstPhaseResult = (NamedList)srsp.getSolrResponse().getResponse().get("firstPhase");
                Object result = serializer.transformToNative(firstPhaseResult, groupSort, (Sort)null, srsp.getShard());
                for (String string : commandSearchGroups.keySet()) {
                    Collection searchGroups;
                    Pair firstPhaseCommandResult = (Pair)result.get(string);
                    Integer groupCount = (Integer)firstPhaseCommandResult.getA();
                    if (groupCount != null) {
                        Integer existingGroupCount = rb.mergedGroupCounts.get(string);
                        rb.mergedGroupCounts.put(string, existingGroupCount != null ? existingGroupCount + groupCount : groupCount);
                    }
                    if ((searchGroups = (Collection)firstPhaseCommandResult.getB()) == null) continue;
                    ((List)commandSearchGroups.get(string)).add(searchGroups);
                    for (SearchGroup searchGroup : searchGroups) {
                        Map map = (Map)tempSearchGroupToShards.get(string);
                        HashSet<String> shards = (HashSet<String>)map.get(searchGroup);
                        if (shards == null) {
                            shards = new HashSet<String>();
                            map.put(searchGroup, shards);
                        }
                        shards.add(srsp.getShard());
                    }
                }
                hitCountDuringFirstPhase += ((Integer)srsp.getSolrResponse().getResponse().get("totalHitCount")).intValue();
            }
            rb.totalHitCount = hitCountDuringFirstPhase;
            rb.firstPhaseElapsedTime = maxElapsedTime;
            for (String groupField : commandSearchGroups.keySet()) {
                List topGroups = (List)commandSearchGroups.get(groupField);
                Collection mergedTopGroups = SearchGroup.merge(topGroups, ss.getOffset(), ss.getCount(), groupSort);
                if (mergedTopGroups == null) continue;
                rb.mergedSearchGroups.put(groupField, mergedTopGroups);
                for (SearchGroup searchGroup : mergedTopGroups) {
                    rb.searchGroupToShards.get(groupField).put(searchGroup, (Set<String>)((Map)tempSearchGroupToShards.get(groupField)).get(searchGroup));
                }
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }
}

