/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.client;

import java.io.IOException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.store.RemoteSegmentLoader;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyApplyDiff
implements NodeStateDiff {
    private static final Logger log = LoggerFactory.getLogger(StandbyApplyDiff.class);
    private final NodeBuilder builder;
    private final SegmentStore store;
    private final boolean hasDataStore;
    private final RemoteSegmentLoader loader;
    private final String path;
    private final boolean logOnly;

    public StandbyApplyDiff(NodeBuilder builder, SegmentStore store, RemoteSegmentLoader loader) {
        this(builder, store, loader, "/", false);
    }

    private StandbyApplyDiff(NodeBuilder builder, SegmentStore store, RemoteSegmentLoader loader, String path, boolean logOnly) {
        this.builder = builder;
        this.store = store;
        this.hasDataStore = store.getBlobStore() != null;
        this.loader = loader;
        this.path = path;
        this.logOnly = logOnly;
    }

    public boolean propertyAdded(PropertyState after) {
        if (!this.loader.isRunning()) {
            return false;
        }
        if (!this.logOnly) {
            this.builder.setProperty(this.binaryCheck(after));
        } else {
            this.binaryCheck(after);
        }
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        if (!this.loader.isRunning()) {
            return false;
        }
        if (!this.logOnly) {
            this.builder.setProperty(this.binaryCheck(after));
        } else {
            this.binaryCheck(after);
        }
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        if (!this.loader.isRunning()) {
            return false;
        }
        if (!this.logOnly) {
            this.builder.removeProperty(before.getName());
        }
        return true;
    }

    private PropertyState binaryCheck(PropertyState property) {
        Type type = property.getType();
        if (type == Type.BINARY) {
            this.binaryCheck((Blob)property.getValue(Type.BINARY), property.getName());
        } else if (type == Type.BINARIES) {
            for (Blob blob : (Iterable)property.getValue(Type.BINARIES)) {
                this.binaryCheck(blob, property.getName());
            }
        }
        return property;
    }

    private void binaryCheck(Blob b, String pName) {
        if (b instanceof SegmentBlob) {
            String blobId;
            SegmentBlob sb = (SegmentBlob)b;
            if (sb.isExternal() && this.hasDataStore && b.getReference() == null && (blobId = sb.getBlobId()) != null) {
                this.readBlob(blobId, pName);
            }
        } else {
            log.warn("Unknown Blob {} at {}, ignoring", (Object)b.getClass().getName(), (Object)(this.path + "#" + pName));
        }
    }

    private void readBlob(String blobId, String pName) {
        Blob read = this.loader.readBlob(blobId);
        if (read != null) {
            try {
                this.store.getBlobStore().writeBlob(read.getNewStream());
            }
            catch (IOException f) {
                throw new IllegalStateException("Unable to persist blob " + blobId + " at " + this.path + "#" + pName, f);
            }
        } else {
            throw new IllegalStateException("Unable to load remote blob " + blobId + " at " + this.path + "#" + pName);
        }
    }

    public boolean childNodeAdded(String name, NodeState after) {
        return this.process(name, "childNodeAdded", EmptyNodeState.EMPTY_NODE, after);
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        return this.process(name, "childNodeChanged", before, after);
    }

    private boolean process(String name, String op, NodeState before, NodeState after) {
        if (!this.loader.isRunning()) {
            return false;
        }
        if (after instanceof SegmentNodeState) {
            if (log.isTraceEnabled()) {
                log.trace("{} {}, readonly binary check {}", new Object[]{op, this.path + name, this.logOnly});
            }
            if (!this.logOnly) {
                RecordId id = ((SegmentNodeState)after).getRecordId();
                this.builder.setChildNode(name, (NodeState)new SegmentNodeState(id));
            }
            if ("checkpoints".equals(name)) {
                return true;
            }
            if (this.hasDataStore) {
                return after.compareAgainstBaseState(before, (NodeStateDiff)new StandbyApplyDiff(this.builder.getChildNode(name), this.store, this.loader, this.path + name + "/", true));
            }
            return true;
        }
        return false;
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        if (!this.loader.isRunning()) {
            return false;
        }
        log.trace("childNodeDeleted {}, RO:{}", (Object)(this.path + name), (Object)this.logOnly);
        if (!this.logOnly) {
            this.builder.getChildNode(name).remove();
        }
        return true;
    }
}

