/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.codec;

public class Messages {
    public static final byte HEADER_RECORD = 0;
    public static final byte HEADER_SEGMENT = 1;
    public static final byte HEADER_BLOB = 2;
    public static final String GET_HEAD = "h";
    public static final String GET_SEGMENT = "s.";
    public static final String GET_BLOB = "b.";
    private static final String MAGIC = "Standby-CMD@";
    private static final String SEPARATOR = ":";

    private static String newRequest(String clientID, String body) {
        return MAGIC + (clientID == null ? "" : clientID.replace(SEPARATOR, "#")) + SEPARATOR + body + "\r\n";
    }

    public static String newGetHeadReq(String clientID) {
        return Messages.newRequest(clientID, GET_HEAD);
    }

    public static String newGetSegmentReq(String clientID, String sid) {
        return Messages.newRequest(clientID, GET_SEGMENT + sid);
    }

    public static String newGetBlobReq(String clientID, String blobId) {
        return Messages.newRequest(clientID, GET_BLOB + blobId);
    }

    public static String extractMessageFrom(String payload) {
        if (payload.startsWith(MAGIC) && payload.length() > MAGIC.length()) {
            int i = payload.indexOf(SEPARATOR);
            return payload.substring(i + 1);
        }
        return null;
    }

    public static String extractClientFrom(String payload) {
        if (payload.startsWith(MAGIC) && payload.length() > MAGIC.length()) {
            payload = payload.substring(MAGIC.length());
            int i = payload.indexOf(SEPARATOR);
            return payload.substring(0, i);
        }
        return null;
    }
}

