/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.codec;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;

public class SegmentEncoder
extends MessageToByteEncoder<Segment> {
    static int EXTRA_HEADERS_LEN = 29;
    private int EXTRA_HEADERS_WO_SIZE = EXTRA_HEADERS_LEN - 4;

    @Override
    protected void encode(ChannelHandlerContext ctx, Segment s, ByteBuf out) throws Exception {
        SegmentId id = s.getSegmentId();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(s.size());
        s.writeTo((OutputStream)baos);
        byte[] segment = baos.toByteArray();
        Hasher hasher = Hashing.murmur3_32().newHasher();
        long hash = hasher.putBytes(segment).hash().padToLong();
        int len = segment.length + this.EXTRA_HEADERS_WO_SIZE;
        out.writeInt(len);
        out.writeByte(1);
        out.writeLong(id.getMostSignificantBits());
        out.writeLong(id.getLeastSignificantBits());
        out.writeLong(hash);
        out.writeBytes(segment);
    }
}

