/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.compression.SnappyFramedEncoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.net.ssl.SSLException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.BlobEncoder;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.RecordIdEncoder;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.SegmentEncoder;
import org.apache.jackrabbit.oak.plugins.segment.standby.jmx.StandbyStatusMBean;
import org.apache.jackrabbit.oak.plugins.segment.standby.server.StandbyServerHandler;
import org.apache.jackrabbit.oak.plugins.segment.standby.store.CommunicationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandbyServer
implements StandbyStatusMBean,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(StandbyServer.class);
    private final int port;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerBootstrap b;
    private final CommunicationObserver observer;
    private final StandbyServerHandler handler;
    private SslContext sslContext;
    private ChannelFuture channelFuture;
    private boolean running;

    public StandbyServer(int port, SegmentStore store) throws CertificateException, SSLException {
        this(port, store, null, false);
    }

    public StandbyServer(int port, SegmentStore store, boolean secure) throws CertificateException, SSLException {
        this(port, store, null, secure);
    }

    public StandbyServer(int port, SegmentStore store, String[] allowedClientIPRanges) throws CertificateException, SSLException {
        this(port, store, allowedClientIPRanges, false);
    }

    public StandbyServer(int port, SegmentStore store, String[] allowedClientIPRanges, boolean secure) throws CertificateException, SSLException {
        this.port = port;
        if (secure) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            this.sslContext = SslContext.newServerContext(ssc.certificate(), ssc.privateKey());
        }
        this.observer = new CommunicationObserver("primary");
        this.handler = new StandbyServerHandler(store, this.observer, allowedClientIPRanges);
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.registerMBean(new StandardMBean(this, StandbyStatusMBean.class), new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("can't register standby status mbean", (Throwable)e);
        }
        this.b = new ServerBootstrap();
        this.b.group(this.bossGroup, this.workerGroup);
        this.b.channel(NioServerSocketChannel.class);
        this.b.option(ChannelOption.TCP_NODELAY, true);
        this.b.option(ChannelOption.SO_REUSEADDR, true);
        this.b.childOption(ChannelOption.TCP_NODELAY, true);
        this.b.childOption(ChannelOption.SO_REUSEADDR, true);
        this.b.childOption(ChannelOption.SO_KEEPALIVE, true);
        this.b.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (StandbyServer.this.sslContext != null) {
                    p.addLast(StandbyServer.this.sslContext.newHandler(ch.alloc()));
                }
                p.addLast(new LineBasedFrameDecoder(8192));
                p.addLast(new StringDecoder(CharsetUtil.UTF_8));
                p.addLast(new SnappyFramedEncoder());
                p.addLast(new RecordIdEncoder());
                p.addLast(new SegmentEncoder());
                p.addLast(new BlobEncoder());
                p.addLast(StandbyServer.this.handler);
            }
        });
    }

    public String getMBeanName() {
        return "org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=" + this.port;
    }

    @Override
    public void close() {
        this.stop();
        this.handler.state = "closing";
        this.observer.unregister();
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            log.error("can't unregister standby status mbean", (Throwable)e);
        }
        if (this.bossGroup != null && !this.bossGroup.isShuttingDown()) {
            this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
        }
        if (this.workerGroup != null && !this.workerGroup.isShuttingDown()) {
            this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
        }
        this.handler.state = "closed";
    }

    private void start(boolean wait) {
        if (this.running) {
            return;
        }
        this.handler.state = "starting";
        final Thread close = new Thread(){

            @Override
            public void run() {
                try {
                    StandbyServer.this.running = true;
                    ((StandbyServer)StandbyServer.this).handler.state = "running";
                    StandbyServer.this.channelFuture.sync().channel().closeFuture().sync();
                }
                catch (InterruptedException e) {
                    StandbyServer.this.stop();
                }
            }
        };
        final ChannelFutureListener bindListener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    close.start();
                } else {
                    log.error("Server failed to start on port " + StandbyServer.this.port + ", will be canceled", future.cause());
                    future.channel().close();
                    new Thread(){

                        @Override
                        public void run() {
                            StandbyServer.this.close();
                        }
                    }.start();
                }
            }
        };
        Future<?> startup = this.bossGroup.submit(new Runnable(){

            @Override
            public void run() {
                StandbyServer.this.channelFuture = StandbyServer.this.b.bind(StandbyServer.this.port);
                StandbyServer.this.channelFuture.addListener(bindListener);
            }
        });
        if (!startup.awaitUninterruptibly(10000L)) {
            log.error("Server failed to start within 10 seconds and will be canceled");
            startup.cancel(true);
        } else if (wait) {
            try {
                close.join();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
    }

    public void startAndWait() {
        this.start(true);
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public String getMode() {
        return "primary";
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void stop() {
        if (this.running) {
            this.running = false;
            this.handler.state = "stopped";
            this.channelFuture.channel().disconnect();
        }
    }

    @Override
    public String getStatus() {
        return this.handler == null ? "initializing" : this.handler.state;
    }
}

