/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.util.OpenSocketFinder;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshClient;

@Singleton
public class CreateSshClientOncePortIsListeningOnNode
implements Function<NodeMetadata, SshClient> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    SshClient.Factory sshFactory;
    private final OpenSocketFinder openSocketFinder;
    private final long timeoutMs;

    @Inject
    public CreateSshClientOncePortIsListeningOnNode(OpenSocketFinder openSocketFinder, ComputeServiceConstants.Timeouts timeouts) {
        this.openSocketFinder = openSocketFinder;
        this.timeoutMs = timeouts.portOpen;
    }

    public SshClient apply(NodeMetadata node) {
        Preconditions.checkState((this.sshFactory != null ? 1 : 0) != 0, (Object)"ssh requested, but no SshModule configured");
        Preconditions.checkNotNull((Object)node.getCredentials(), (String)"no credentials found for node %s", (Object[])new Object[]{node.getId()});
        Preconditions.checkNotNull((Object)node.getCredentials().identity, (String)"no login identity found for node %s", (Object[])new Object[]{node.getId()});
        Preconditions.checkNotNull((Object)node.getCredentials().credential, (String)"no credential found for %s on node %s", (Object[])new Object[]{node.getCredentials().identity, node.getId()});
        HostAndPort socket = this.openSocketFinder.findOpenSocketOnNode(node, node.getLoginPort(), this.timeoutMs, TimeUnit.MILLISECONDS);
        return this.sshFactory.create(socket, node.getCredentials());
    }
}

