/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.config.VirtualBoxConstants;
import org.jclouds.virtualbox.functions.IMachineToVmSpec;
import org.jclouds.virtualbox.functions.TakeSnapshotIfNotAlreadyAttached;
import org.jclouds.virtualbox.functions.admin.UnregisterMachineIfExistsAndDeleteItsMedia;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.CloneMode;
import org.virtualbox_4_2.CloneOptions;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISnapshot;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class VirtualBoxImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private ComputeServiceAdapter<IMachine, Hardware, Image, Location> vboxAdapter;
    private Function<IMachine, NodeMetadata> machineToNode;
    private Supplier<VirtualBoxManager> manager;
    private String workingDir;
    private boolean isLinkedClone = true;
    private Function<IMachine, Image> imachineToImage;
    private MachineUtils machineUtils;

    @Inject
    public VirtualBoxImageExtension(ComputeServiceAdapter<IMachine, Hardware, Image, Location> vboxAdapter, Function<IMachine, NodeMetadata> machineToNode, Supplier<VirtualBoxManager> manager, @Named(value="jclouds.virtualbox.workingdir") String workingDir, Function<IMachine, Image> imachineToImage, MachineUtils machineUtils) {
        this.vboxAdapter = vboxAdapter;
        this.machineToNode = machineToNode;
        this.manager = manager;
        this.workingDir = workingDir == null ? VirtualBoxConstants.VIRTUALBOX_DEFAULT_DIR : workingDir;
        this.imachineToImage = imachineToImage;
        this.machineUtils = machineUtils;
    }

    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        Optional<NodeMetadata> sourceNode = this.getNodeById(id);
        Preconditions.checkState((boolean)sourceNode.isPresent(), (Object)(" there is no node with id " + id));
        String vmName = "jclouds-image-0x0-" + name;
        IMachine vm = null;
        try {
            vm = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName);
        }
        catch (Exception e) {
            // empty catch block
        }
        Preconditions.checkState((vm == null ? 1 : 0) != 0, (Object)(" a machine exists with name: " + vmName));
        return new ImageTemplateBuilder.CloneImageTemplateBuilder().name(vmName).nodeId(id).build();
    }

    public ListenableFuture<Image> createImage(ImageTemplate template) {
        Preconditions.checkState((boolean)(template instanceof CloneImageTemplate), (Object)" vbox image extension only supports cloning for the moment.");
        CloneImageTemplate cloneTemplate = (CloneImageTemplate)CloneImageTemplate.class.cast(template);
        IMachine source = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(cloneTemplate.getSourceNodeId());
        String flags = "";
        ImmutableList groups = ImmutableList.of();
        String group = "";
        String settingsFile = ((VirtualBoxManager)this.manager.get()).getVBox().composeMachineFilename(template.getName(), group, flags, this.workingDir);
        IMachine clonedMachine = ((VirtualBoxManager)this.manager.get()).getVBox().createMachine(settingsFile, template.getName(), (List)groups, source.getOSTypeId(), flags);
        ArrayList options = Lists.newArrayList();
        if (this.isLinkedClone) {
            options.add(CloneOptions.Link);
        }
        ISnapshot currentSnapshot = new TakeSnapshotIfNotAlreadyAttached(this.manager, "pre-image-spawn", "before spawning " + template.getName(), this.logger).apply(source);
        Preconditions.checkNotNull((Object)currentSnapshot);
        IProgress progress = currentSnapshot.getMachine().cloneTo(clonedMachine, CloneMode.MachineState, (List)options);
        progress.waitForCompletion(Integer.valueOf(-1));
        this.logger.debug(String.format("<< master(%s) is cloned correctly to vm(%s)", source.getName(), clonedMachine.getName()), new Object[0]);
        ((VirtualBoxManager)this.manager.get()).getVBox().registerMachine(clonedMachine);
        return Futures.immediateFuture((Object)this.imachineToImage.apply((Object)clonedMachine));
    }

    public boolean deleteImage(String id) {
        try {
            IMachine machine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine("jclouds-image-0x0-" + id);
            this.machineUtils.applyForMachine(machine.getId(), new UnregisterMachineIfExistsAndDeleteItsMedia(new IMachineToVmSpec().apply(machine)));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "Could not delete machine with id %s ", new Object[]{id});
            return false;
        }
        return true;
    }

    private Optional<NodeMetadata> getNodeById(final String id) {
        return Iterables.tryFind((Iterable)Iterables.transform((Iterable)this.vboxAdapter.listNodes(), this.machineToNode), (Predicate)new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata input) {
                return input.getId().equals(id);
            }
        });
    }
}

