/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class BridgedIf {
    private final String name;
    private final String guid;
    private final String dhcp;
    private final String ipAddress;
    private final String networkMask;
    private final String ipv6Address;
    private final String ipv6NetworkMask;
    private final String mediumType;
    private final String status;

    public static Builder builder() {
        return new Builder();
    }

    public BridgedIf(String name, String guid, String dhcp, String ipAddress, String networkMask, String ipv6Address, String iv6NetworkMask, String mediumType, String status) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"bridgedIf name can't be null");
        this.guid = guid;
        this.dhcp = dhcp;
        this.ipAddress = (String)Preconditions.checkNotNull((Object)ipAddress, (Object)"bridgedIf ipAddress can't be null");
        this.networkMask = networkMask;
        this.ipv6Address = ipv6Address;
        this.ipv6NetworkMask = iv6NetworkMask;
        this.mediumType = mediumType;
        this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"bridgedIf status can't be null");
    }

    public String getName() {
        return this.name;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getDhcp() {
        return this.dhcp;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getNetworkMask() {
        return this.networkMask;
    }

    public String getIpv6Address() {
        return this.ipv6Address;
    }

    public String getIpv6NetworkMask() {
        return this.ipv6NetworkMask;
    }

    public String getMediumType() {
        return this.mediumType;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BridgedIf) {
            BridgedIf other = (BridgedIf)o;
            return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.dhcp, (Object)other.dhcp) && Objects.equal((Object)this.ipAddress, (Object)other.ipAddress) && Objects.equal((Object)this.networkMask, (Object)other.networkMask) && Objects.equal((Object)this.mediumType, (Object)other.mediumType) && Objects.equal((Object)this.status, (Object)other.status);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.guid, this.dhcp, this.ipAddress, this.networkMask, this.ipv6Address, this.ipv6NetworkMask, this.mediumType, this.status});
    }

    public String toString() {
        return "BridgedIf{name=" + this.name + ", dhcp=" + this.dhcp + ", ipAddress=" + this.ipAddress + ", networkMask=" + this.networkMask + ", ipv6Address=" + this.ipv6Address + ", ipv6NetworkMask=" + this.ipv6NetworkMask + ", mediumType=" + this.mediumType + ", status=" + this.status + '}';
    }

    public static class Builder {
        private String name;
        private String guid;
        private String dhcp;
        private String ipAddress;
        private String networkMask;
        private String ipv6Address;
        private String iv6NetworkMask;
        private String mediumType;
        private String status;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder guid(String guid) {
            this.guid = guid;
            return this;
        }

        public Builder dhcp(String dhcp) {
            this.dhcp = dhcp;
            return this;
        }

        public Builder ip(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder networkMask(String networkMask) {
            this.networkMask = networkMask;
            return this;
        }

        public Builder ipv6(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public Builder ipv6networkMask(String iv6NetworkMask) {
            this.iv6NetworkMask = iv6NetworkMask;
            return this;
        }

        public Builder mediumType(String mediumType) {
            this.mediumType = mediumType;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public BridgedIf build() {
            return new BridgedIf(this.name, this.guid, this.dhcp, this.ipAddress, this.networkMask, this.ipv6Address, this.iv6NetworkMask, this.mediumType, this.status);
        }
    }
}

