/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.virtualbox_4_2.DeviceType;

public class DeviceDetails {
    private final int port;
    private final int deviceSlot;
    private final DeviceType deviceType;

    public DeviceDetails(int port, int deviceSlot, DeviceType deviceType) {
        this.port = port;
        this.deviceSlot = deviceSlot;
        this.deviceType = (DeviceType)Preconditions.checkNotNull((Object)deviceType, (Object)"deviceType can't be null");
    }

    public int getPort() {
        return this.port;
    }

    public int getDeviceSlot() {
        return this.deviceSlot;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DeviceDetails) {
            DeviceDetails other = (DeviceDetails)o;
            return Objects.equal((Object)this.port, (Object)other.port) && Objects.equal((Object)this.deviceSlot, (Object)other.deviceSlot) && Objects.equal((Object)this.deviceType, (Object)other.deviceType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.port, this.deviceSlot, this.deviceType});
    }

    public String toString() {
        return "DeviceDetails{port=" + this.port + ", deviceSlot=" + this.deviceSlot + ", deviceType=" + this.deviceType + '}';
    }

    public static class Builder {
        private int port;
        private int deviceSlot;
        private DeviceType deviceType;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder deviceSlot(int slot) {
            this.deviceSlot = slot;
            return this;
        }

        public DeviceDetails build() {
            Preconditions.checkNotNull((Object)this.deviceType, (Object)"deviceType can't be null");
            return new DeviceDetails(this.port, this.deviceSlot, this.deviceType);
        }
    }
}

