/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.jaxws.RuntimeFaultMsg;

public enum ErrorCode {
    VBOX_E_OBJECT_NOT_FOUND(2159738881L),
    VBOX_E_INVALID_VM_STATE(2159738882L),
    VBOX_E_VM_ERROR(2159738883L),
    VBOX_E_FILE_ERROR(2159738884L),
    VBOX_E_IPRT_ERROR(2159738885L),
    VBOX_E_PDM_ERROR(2159738886L),
    VBOX_E_INVALID_OBJECT_STATE(2159738887L),
    VBOX_E_HOST_ERROR(0x80BB0008L),
    VBOX_E_NOT_SUPPORTED(2159738889L),
    VBOX_E_XML_ERROR(2159738890L),
    VBOX_E_INVALID_SESSION_STATE(0x80BB000BL),
    VBOX_E_OBJECT_IN_USE(2159738892L),
    VBOX_E_ACCESSDENIED(2147942405L),
    VBOX_E_POINTER(2147500035L),
    VBOX_E_FAIL(2147500037L),
    VBOX_E_NOTIMPL(2147500033L),
    VBOX_E_OUTOFMEMORY(2147942414L),
    VBOX_E_INVALIDARG(2147942487L),
    VBOX_E_UNEXPECTED(0x8000FFFFL),
    VBOX_E_UNKNOWN_ERROR_CODE(-1L),
    VBOX_E_ERROR_CODE_UNAVAILABLE(-2L);

    private final long code;
    private static final Map<Long, ErrorCode> TABLE;

    private ErrorCode(long code) {
        this.code = code;
    }

    public static ErrorCode valueOf(VBoxException vboxException) {
        Throwable backend = vboxException.getWrapped();
        if (backend instanceof RuntimeFaultMsg) {
            RuntimeFaultMsg faultCode = (RuntimeFaultMsg)backend;
            int resultCode = faultCode.getFaultInfo().getResultCode();
            ErrorCode errorCode = TABLE.get(ErrorCode.unsignedIntToLong(resultCode));
            if (errorCode != null) {
                return errorCode;
            }
            return VBOX_E_UNKNOWN_ERROR_CODE;
        }
        return VBOX_E_ERROR_CODE_UNAVAILABLE;
    }

    private static long unsignedIntToLong(int faultCode) {
        return (long)faultCode & 0xFFFFFFFFL;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ErrorCode errorCode : ErrorCode.values()) {
            builder.put((Object)errorCode.code, (Object)errorCode);
        }
        TABLE = builder.build();
    }
}

