/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class IsoSpec {
    private final String installationKeySequence;
    private final String sourcePath;

    public IsoSpec(String sourcePath, String installationKeySequence) {
        this.sourcePath = (String)Preconditions.checkNotNull((Object)sourcePath, (Object)"sourcePath can't be null");
        this.installationKeySequence = (String)Preconditions.checkNotNull((Object)installationKeySequence, (Object)"installationKeySequence can't be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstallationKeySequence() {
        return this.installationKeySequence;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IsoSpec) {
            IsoSpec other = (IsoSpec)o;
            return Objects.equal((Object)this.sourcePath, (Object)other.sourcePath) && Objects.equal((Object)this.installationKeySequence, (Object)other.installationKeySequence);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sourcePath, this.installationKeySequence});
    }

    public String toString() {
        return "IsoSpec{sourcePath='" + this.sourcePath + '\'' + "installationKeySequence='" + this.installationKeySequence + '\'' + '}';
    }

    public static class Builder {
        private String installationSequence;
        private String sourcePath;

        public Builder installationScript(String installationSequence) {
            this.installationSequence = installationSequence;
            return this;
        }

        public Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public IsoSpec build() {
            return new IsoSpec(this.sourcePath, this.installationSequence);
        }
    }
}

