/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.virtualbox.domain.IsoSpec;
import org.jclouds.virtualbox.domain.NetworkSpec;
import org.jclouds.virtualbox.domain.VmSpec;

public class MasterSpec {
    private VmSpec vmSpec;
    private IsoSpec isoSpec;
    private NetworkSpec networkSpec;
    private LoginCredentials loginCredentials;

    public static Builder builder() {
        return new Builder();
    }

    private MasterSpec(VmSpec vmSpec, IsoSpec isoSpec, NetworkSpec networkSpec, LoginCredentials loginCredentials) {
        this.vmSpec = (VmSpec)Preconditions.checkNotNull((Object)vmSpec, (Object)"vmSpec can't be null");
        this.isoSpec = (IsoSpec)Preconditions.checkNotNull((Object)isoSpec, (Object)"isoSpec can't be null");
        this.networkSpec = (NetworkSpec)Preconditions.checkNotNull((Object)networkSpec, (Object)"networkSpec can't be null");
        this.loginCredentials = loginCredentials;
    }

    public VmSpec getVmSpec() {
        return this.vmSpec;
    }

    public IsoSpec getIsoSpec() {
        return this.isoSpec;
    }

    public NetworkSpec getNetworkSpec() {
        return this.networkSpec;
    }

    public LoginCredentials getLoginCredentials() {
        return this.loginCredentials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MasterSpec) {
            MasterSpec other = (MasterSpec)o;
            return Objects.equal((Object)this.vmSpec, (Object)other.vmSpec) && Objects.equal((Object)this.isoSpec, (Object)other.isoSpec) && Objects.equal((Object)this.networkSpec, (Object)other.networkSpec);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.vmSpec, this.isoSpec, this.networkSpec});
    }

    public String toString() {
        return "IMachineSpec{vmSpec=" + this.vmSpec + ", isoSpec=" + this.isoSpec + ", networkSpec=" + this.networkSpec + '}';
    }

    public static class Builder {
        private VmSpec vmSpec;
        private IsoSpec isoSpec;
        private NetworkSpec networkSpec;
        private LoginCredentials loginCredentials;

        public Builder vm(VmSpec vmSpec) {
            this.vmSpec = vmSpec;
            return this;
        }

        public Builder network(NetworkSpec networkSpec) {
            this.networkSpec = networkSpec;
            return this;
        }

        public Builder iso(IsoSpec isoSpec) {
            this.isoSpec = isoSpec;
            return this;
        }

        public Builder credentials(LoginCredentials loginCredentials) {
            this.loginCredentials = loginCredentials;
            return this;
        }

        public MasterSpec build() {
            return new MasterSpec(this.vmSpec, this.isoSpec, this.networkSpec, this.loginCredentials);
        }
    }
}

