/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.virtualbox.domain.RedirectRule;
import org.virtualbox_4_2.NATProtocol;
import org.virtualbox_4_2.NetworkAttachmentType;

public class NetworkAdapter {
    private final NetworkAttachmentType networkAttachmentType;
    private final String macAddress;
    private final Set<RedirectRule> redirectRules;
    private final String staticIp;

    public NetworkAdapter(NetworkAttachmentType networkAttachmentType, String macAddress, Set<RedirectRule> redirectRules, String staticIp) {
        this.networkAttachmentType = (NetworkAttachmentType)Preconditions.checkNotNull((Object)networkAttachmentType, (Object)"networkAttachmentType can't be null");
        this.macAddress = macAddress;
        this.redirectRules = ImmutableSet.copyOf(redirectRules);
        this.staticIp = staticIp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public NetworkAttachmentType getNetworkAttachmentType() {
        return this.networkAttachmentType;
    }

    public Set<RedirectRule> getRedirectRules() {
        return Collections.unmodifiableSet(this.redirectRules);
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getStaticIp() {
        return this.staticIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NetworkAdapter) {
            NetworkAdapter other = (NetworkAdapter)o;
            return Objects.equal((Object)this.networkAttachmentType, (Object)other.networkAttachmentType) && Objects.equal((Object)this.macAddress, (Object)other.macAddress) && Objects.equal(this.redirectRules, other.redirectRules);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.networkAttachmentType, this.macAddress, this.redirectRules});
    }

    public String toString() {
        return "NetworkAdapter{networkAttachmentType=" + this.networkAttachmentType + ", macAddress=" + this.macAddress + ", redirectRules=" + this.redirectRules + '}';
    }

    public static class Builder {
        private NetworkAttachmentType networkAttachmentType;
        private String macAddress;
        private Set<RedirectRule> redirectRules = Sets.newLinkedHashSet();
        private String staticIp;

        public Builder networkAttachmentType(NetworkAttachmentType networkAttachmentType) {
            this.networkAttachmentType = networkAttachmentType;
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public Builder tcpRedirectRule(String host, int hostPort, String guest, int guestPort) {
            this.redirectRules.add(new RedirectRule(NATProtocol.TCP, host, hostPort, guest, guestPort));
            return this;
        }

        public Builder udpRedirectRule(String host, int hostPort, String guest, int guestPort) {
            this.redirectRules.add(new RedirectRule(NATProtocol.UDP, host, hostPort, guest, guestPort));
            return this;
        }

        public Builder staticIp(@Nullable String staticIp) {
            this.staticIp = staticIp;
            return this;
        }

        public NetworkAdapter build() {
            return new NetworkAdapter(this.networkAttachmentType, this.macAddress, this.redirectRules, this.staticIp);
        }
    }
}

