/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.virtualbox.domain.NetworkAdapter;

public class NetworkInterfaceCard {
    private final long slot;
    private final NetworkAdapter networkAdapter;
    private final String hostInterfaceName;
    private final boolean enabled;

    public NetworkInterfaceCard(long slot, NetworkAdapter networkAdapter, String hostInterfaceName, boolean enabled) {
        this.slot = (Long)Preconditions.checkNotNull((Object)slot, (Object)"slot can't be null");
        this.networkAdapter = (NetworkAdapter)Preconditions.checkNotNull((Object)networkAdapter, (Object)"networkAdapter can't be null");
        this.hostInterfaceName = hostInterfaceName;
        this.enabled = enabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getSlot() {
        return this.slot;
    }

    public NetworkAdapter getNetworkAdapter() {
        return this.networkAdapter;
    }

    public String getHostInterfaceName() {
        return this.hostInterfaceName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NetworkInterfaceCard) {
            NetworkInterfaceCard other = (NetworkInterfaceCard)o;
            return Objects.equal((Object)this.slot, (Object)other.slot) && Objects.equal((Object)this.networkAdapter, (Object)other.networkAdapter) && Objects.equal((Object)this.enabled, (Object)other.enabled);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.slot, this.networkAdapter, this.enabled});
    }

    public String toString() {
        return "NetworkInterfaceCard{slot=" + this.slot + ", networkAdapter=" + this.networkAdapter + ", enabled=" + this.enabled + '}';
    }

    public static class Builder {
        private long slot = 0L;
        private NetworkAdapter networkAdapter;
        private String hostInterfaceName;
        private boolean enabled = true;

        public Builder slot(long slot) {
            Preconditions.checkArgument((slot >= 0L && slot < 4L ? 1 : 0) != 0, (String)"must be 0, 1, 2, 3: %s", (Object[])new Object[]{slot});
            this.slot = slot;
            return this;
        }

        public Builder addNetworkAdapter(NetworkAdapter networkAdapter) {
            this.networkAdapter = networkAdapter;
            return this;
        }

        public Builder addHostInterfaceName(String hostInterfaceName) {
            this.hostInterfaceName = hostInterfaceName;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public NetworkInterfaceCard build() {
            return new NetworkInterfaceCard(this.slot, this.networkAdapter, this.hostInterfaceName, this.enabled);
        }
    }
}

