/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;

public class NetworkSpec {
    private final List<NetworkInterfaceCard> networkInterfaceCards;

    public NetworkSpec(List<NetworkInterfaceCard> networkInterfaceCards) {
        this.networkInterfaceCards = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(networkInterfaceCards, (Object)"networkInterfaceCards can't be null")));
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<NetworkInterfaceCard> getNetworkInterfaceCards() {
        return this.networkInterfaceCards;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NetworkSpec) {
            NetworkSpec other = (NetworkSpec)o;
            return Objects.equal(this.networkInterfaceCards, other.networkInterfaceCards);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.networkInterfaceCards});
    }

    public String toString() {
        return "NetworkSpec{networkInterfaceCards= " + this.networkInterfaceCards + '}';
    }

    public static class Builder {
        private List<NetworkInterfaceCard> networkInterfaceCards = Lists.newArrayList();

        public Builder addNIC(NetworkInterfaceCard networkInterfaceCard) {
            this.networkInterfaceCards.add(networkInterfaceCard);
            return this;
        }

        public NetworkSpec build() {
            return new NetworkSpec(this.networkInterfaceCards);
        }
    }
}

