/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.virtualbox.domain.DeviceDetails;
import org.jclouds.virtualbox.domain.HardDisk;
import org.jclouds.virtualbox.domain.IsoImage;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.StorageBus;

public class StorageController {
    private final String name;
    private final StorageBus bus;
    private Set<HardDisk> hardDisks;
    private Set<IsoImage> isoImages;

    public StorageController(String name, StorageBus bus, Set<HardDisk> hardDisks, Set<IsoImage> isoImages) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"storage name can't be null");
        this.bus = (StorageBus)Preconditions.checkNotNull((Object)bus, (Object)"bus can't be null");
        this.hardDisks = (Set)Preconditions.checkNotNull(hardDisks, (Object)"hardDisks can't be null");
        this.isoImages = (Set)Preconditions.checkNotNull(isoImages, (Object)"isoImages can't be null");
    }

    public String getName() {
        return this.name;
    }

    public StorageBus getBus() {
        return this.bus;
    }

    public HardDisk getHardDisk(String diskName) {
        Iterable hardDisks = Iterables.filter(this.getHardDisks(), (Predicate)new HardDiskPredicate(diskName));
        return (HardDisk)Iterables.getFirst((Iterable)hardDisks, (Object)HardDisk.builder().diskpath("notfound").controllerPort(0).deviceSlot(0).build());
    }

    public Set<HardDisk> getHardDisks() {
        return this.hardDisks;
    }

    public Set<IsoImage> getIsoImages() {
        return this.isoImages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StorageController) {
            StorageController other = (StorageController)o;
            return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.bus, (Object)other.bus) && Objects.equal(this.hardDisks, other.hardDisks) && Objects.equal(this.isoImages, other.isoImages);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.bus, this.hardDisks, this.isoImages});
    }

    public String toString() {
        return "StorageController{name='" + this.name + '\'' + ", bus=" + this.bus + ", hardDisks=" + this.hardDisks + ", isoImages=" + this.isoImages + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class HardDiskPredicate
    implements Predicate<HardDisk> {
        private String diskName;

        public HardDiskPredicate(String diskName) {
            this.diskName = diskName;
        }

        public boolean apply(@Nullable HardDisk hardDisk) {
            return hardDisk.getName().equals(this.diskName);
        }
    }

    public static class Builder {
        private String name;
        private StorageBus bus;
        private Set<HardDisk> hardDisks = Sets.newHashSet();
        private Set<IsoImage> dvds = Sets.newHashSet();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder bus(StorageBus bus) {
            this.bus = bus;
            return this;
        }

        public Builder attachISO(int controllerPort, int deviceSlot, String sourcePath) {
            this.dvds.add(new IsoImage(new DeviceDetails(controllerPort, deviceSlot, DeviceType.DVD), sourcePath));
            return this;
        }

        public Builder attachHardDisk(HardDisk hardDisk) {
            this.hardDisks.add(hardDisk);
            return this;
        }

        public StorageController build() {
            Preconditions.checkNotNull((Object)this.name);
            Preconditions.checkNotNull((Object)this.bus);
            return new StorageController(this.name, this.bus, this.hardDisks, this.dvds);
        }
    }
}

