/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.jclouds.virtualbox.domain.StorageController;
import org.virtualbox_4_2.CleanupMode;

public class VmSpec {
    private final String vmName;
    private final String osTypeId;
    private final String vmId;
    private final long memory;
    private final boolean forceOverwrite;
    private final Set<StorageController> controllers;
    private final CleanupMode cleanupMode;

    public VmSpec(String vmId, String vmName, String osTypeId, long memory, String guestUser, String guestPassword, boolean forceOverwrite, Set<StorageController> controllers, CleanupMode cleanupMode) {
        this.vmId = (String)Preconditions.checkNotNull((Object)vmId, (Object)"vmId can't be null");
        this.vmName = (String)Preconditions.checkNotNull((Object)vmName, (Object)"vmName can't be null");
        this.osTypeId = (String)Preconditions.checkNotNull((Object)osTypeId, (Object)"osTypeId can't be null");
        Preconditions.checkArgument((memory > 0L ? 1 : 0) != 0, (Object)"memory must be > 0");
        this.memory = memory;
        this.controllers = (Set)Preconditions.checkNotNull(controllers, (Object)"controllers can't be null");
        this.cleanupMode = (CleanupMode)Preconditions.checkNotNull((Object)cleanupMode, (Object)"cleanupMode can't be null");
        this.forceOverwrite = forceOverwrite;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVmId() {
        return this.vmId;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getOsTypeId() {
        return this.osTypeId;
    }

    public long getMemory() {
        return this.memory;
    }

    public boolean isForceOverwrite() {
        return this.forceOverwrite;
    }

    public Set<StorageController> getControllers() {
        return Collections.unmodifiableSet(this.controllers);
    }

    public CleanupMode getCleanupMode() {
        return this.cleanupMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VmSpec) {
            VmSpec other = (VmSpec)o;
            return Objects.equal((Object)this.vmId, (Object)other.vmId) && Objects.equal((Object)this.vmName, (Object)other.vmName) && Objects.equal((Object)this.osTypeId, (Object)other.osTypeId) && Objects.equal((Object)this.memory, (Object)other.memory) && Objects.equal((Object)this.forceOverwrite, (Object)other.forceOverwrite) && Objects.equal(this.controllers, other.controllers) && Objects.equal((Object)this.cleanupMode, (Object)other.cleanupMode);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.vmId, this.vmName, this.osTypeId, this.memory, this.forceOverwrite, this.controllers});
    }

    public String toString() {
        return "VmSpecification{vmName='" + this.vmName + '\'' + ", osTypeId='" + this.osTypeId + '\'' + ", memory='" + this.memory + '\'' + ", vmId='" + this.vmId + '\'' + '\'' + ", forceOverwrite=" + this.forceOverwrite + ", controllers=" + this.controllers + ", cleanupMode=" + this.cleanupMode + '}';
    }

    public static class Builder {
        private Set<StorageController> controllers = Sets.newHashSet();
        private String name;
        private String id;
        private String osTypeId = "";
        private boolean forceOverwrite = true;
        private long memory;
        private String guestUser;
        private String guestPassword;
        private CleanupMode cleanUpMode;

        public Builder controller(StorageController controller) {
            this.controllers.add(controller);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder osTypeId(String osTypeId) {
            this.osTypeId = osTypeId;
            return this;
        }

        public Builder forceOverwrite(boolean forceOverwrite) {
            this.forceOverwrite = forceOverwrite;
            return this;
        }

        public Builder memoryMB(int memorySize) {
            this.memory = memorySize;
            return this;
        }

        public Builder cleanUpMode(CleanupMode cleanupMode) {
            this.cleanUpMode = cleanupMode;
            return this;
        }

        public Builder guestUser(String guestUser) {
            this.guestUser = guestUser;
            return this;
        }

        public Builder guestPassword(String guestPassword) {
            this.guestPassword = guestPassword;
            return this;
        }

        public VmSpec build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"name");
            Preconditions.checkNotNull((Object)this.id, (Object)"id");
            Preconditions.checkArgument((this.memory > 0L ? 1 : 0) != 0, (Object)"Memory must be set");
            return new VmSpec(this.id, this.name, this.osTypeId, this.memory, this.guestUser, this.guestPassword, this.forceOverwrite, this.controllers, this.cleanUpMode);
        }
    }
}

