/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.LoginCredentials;

public class YamlImage {
    public String id;
    public String name;
    public String description;
    public String hostname;
    public String location_id;
    public String os_arch;
    public String os_family;
    public String os_description;
    public String os_version;
    public String iso_md5;
    public String iso;
    public String keystroke_sequence;
    public String preseed_cfg;
    public int login_port = 22;
    public boolean os_64bit;
    public String group;
    public List<String> tags = Lists.newArrayList();
    public Map<String, String> metadata = Maps.newLinkedHashMap();
    public String username;
    public String credential;
    public String credential_url;
    public String sudo_password;
    public static final Function<YamlImage, Image> toImage = new Function<YamlImage, Image>(){

        public Image apply(YamlImage arg0) {
            if (arg0 == null) {
                return null;
            }
            OsFamily family = ComputeServiceUtils.parseOsFamilyOrUnrecognized((String)arg0.os_family);
            OperatingSystem operatingSystem = OperatingSystem.builder().description(arg0.os_description).family(family).version(arg0.os_version).is64Bit(arg0.os_64bit).arch(arg0.os_arch).build();
            return new ImageBuilder().id(arg0.id).name(arg0.name).description(arg0.description).operatingSystem(operatingSystem).status(Image.Status.AVAILABLE).defaultCredentials(LoginCredentials.builder().user(arg0.username).password(arg0.credential).authenticateSudo(true).build()).build();
        }
    };

    public Image toImage() {
        return (Image)toImage.apply((Object)this);
    }

    public String toString() {
        return "YamlImage [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", hostname=" + this.hostname + ", location_id=" + this.location_id + ", os_arch=" + this.os_arch + ", os_family=" + this.os_family + ", os_description=" + this.os_description + ", os_version=" + this.os_version + ", iso=" + this.iso + ", keystroke_sequence=" + this.keystroke_sequence + ", preseed_cfg=" + this.preseed_cfg + ", login_port=" + this.login_port + ", os_64bit=" + this.os_64bit + ", group=" + this.group + ", tags=" + this.tags + ", metadata=" + this.metadata + ", username=" + this.username + ", credential=" + this.credential + ", credential_url=" + this.credential_url + ", sudo_password=" + this.sudo_password + "]";
    }
}

