/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;
import org.jclouds.virtualbox.functions.AttachBridgedAdapterToMachine;
import org.jclouds.virtualbox.functions.AttachHostOnlyAdapter;
import org.jclouds.virtualbox.functions.AttachNATAdapterToMachineIfNotAlreadyExists;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.NetworkAttachmentType;

public class AttachNicToMachine
implements Function<NetworkInterfaceCard, Void> {
    private final String vmName;
    private final MachineUtils machineUtils;

    public AttachNicToMachine(String vmName, MachineUtils machineUtils) {
        this.vmName = (String)Preconditions.checkNotNull((Object)vmName, (Object)"vmName can't be null");
        this.machineUtils = (MachineUtils)Preconditions.checkNotNull((Object)machineUtils, (Object)"machineUtils can't be null");
    }

    public Void apply(NetworkInterfaceCard nic) {
        if (this.hasNatAdapter(nic)) {
            return this.machineUtils.writeLockMachineAndApply(this.vmName, new AttachNATAdapterToMachineIfNotAlreadyExists(nic));
        }
        if (this.hasBridgedAdapter(nic)) {
            return this.machineUtils.writeLockMachineAndApply(this.vmName, new AttachBridgedAdapterToMachine(nic));
        }
        if (this.hasHostOnlyAdapter(nic)) {
            return this.machineUtils.writeLockMachineAndApply(this.vmName, new AttachHostOnlyAdapter(nic));
        }
        return null;
    }

    private boolean hasNatAdapter(NetworkInterfaceCard nic) {
        return nic.getNetworkAdapter().getNetworkAttachmentType().equals((Object)NetworkAttachmentType.NAT);
    }

    private boolean hasBridgedAdapter(NetworkInterfaceCard nic) {
        return nic.getNetworkAdapter().getNetworkAttachmentType().equals((Object)NetworkAttachmentType.Bridged);
    }

    private boolean hasHostOnlyAdapter(NetworkInterfaceCard nic) {
        return nic.getNetworkAdapter().getNetworkAttachmentType().equals((Object)NetworkAttachmentType.HostOnly);
    }
}

