/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.virtualbox.domain.BridgedIf;

@Singleton
public class BridgedIfStringToBridgedIf
implements Function<String, BridgedIf> {
    private static final String BRIDGED_IF_STATUS = "Status";
    private static final String BRIDGED_IF_MEDIUM_TYPE = "MediumType";
    private static final String BRIDGED_IF_NETWORK_MASK = "NetworkMask";
    private static final String BRIDGED_IF_IP_ADDRESS = "IPAddress";
    private static final String BRIDGED_IF_GUID = "GUID";
    private static final String BRIDGED_IF_NAME = "Name";

    @Inject
    public BridgedIfStringToBridgedIf() {
    }

    public BridgedIf apply(String rawBridgedIf) {
        Preconditions.checkNotNull((Object)rawBridgedIf, (Object)"bridged interface can't be null");
        String transformedBridgedIf = this.transformRawBridgedIf(rawBridgedIf);
        Map bridgedIfMap = Splitter.on((String)"\n").omitEmptyStrings().withKeyValueSeparator("=").split((CharSequence)transformedBridgedIf);
        return BridgedIf.builder().name(this.getValueFromMap(bridgedIfMap, BRIDGED_IF_NAME)).guid(this.getValueFromMap(bridgedIfMap, BRIDGED_IF_GUID)).ip(this.getValueFromMap(bridgedIfMap, BRIDGED_IF_IP_ADDRESS)).networkMask(this.getValueFromMap(bridgedIfMap, BRIDGED_IF_NETWORK_MASK)).mediumType(this.getValueFromMap(bridgedIfMap, BRIDGED_IF_MEDIUM_TYPE)).status(this.getValueFromMap(bridgedIfMap, BRIDGED_IF_STATUS)).build();
    }

    private String getValueFromMap(Map<String, String> map, String key) {
        return map.get(key).trim();
    }

    private String transformRawBridgedIf(String rawBridgedIf) {
        Iterable transformedLines = Iterables.transform((Iterable)Splitter.on((String)"\n").split((CharSequence)rawBridgedIf), (Function)new Function<String, String>(){

            public String apply(String line) {
                return line.replaceFirst(":", "=");
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : transformedLines) {
            stringBuilder.append(line + "\n");
        }
        return stringBuilder.toString();
    }
}

