/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.domain.CloneSpec;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;
import org.jclouds.virtualbox.domain.NetworkSpec;
import org.jclouds.virtualbox.domain.VmSpec;
import org.jclouds.virtualbox.functions.AttachNicToMachine;
import org.jclouds.virtualbox.functions.TakeSnapshotIfNotAlreadyAttached;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.CloneMode;
import org.virtualbox_4_2.CloneOptions;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISnapshot;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.VirtualBoxManager;

public class CloneAndRegisterMachineFromIMachineIfNotAlreadyExists
implements Function<CloneSpec, IMachine> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<VirtualBoxManager> manager;
    private final String workingDir;
    private final MachineUtils machineUtils;

    @Inject
    public CloneAndRegisterMachineFromIMachineIfNotAlreadyExists(Supplier<VirtualBoxManager> manager, @Named(value="jclouds.virtualbox.workingdir") String workingDir, MachineUtils machineUtils) {
        this.manager = manager;
        this.workingDir = workingDir;
        this.machineUtils = machineUtils;
    }

    public IMachine apply(CloneSpec cloneSpec) {
        VmSpec vmSpec = cloneSpec.getVmSpec();
        try {
            ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmSpec.getVmName());
            throw new IllegalStateException("Machine " + vmSpec.getVmName() + " is already registered.");
        }
        catch (VBoxException e) {
            if (this.machineNotFoundException(e)) {
                return this.cloneMachine(cloneSpec);
            }
            throw e;
        }
    }

    private boolean machineNotFoundException(VBoxException e) {
        return e.getMessage().contains("VirtualBox error: Could not find a registered machine named ") || e.getMessage().contains("Could not find a registered machine with UUID {");
    }

    private IMachine cloneMachine(CloneSpec cloneSpec) {
        VmSpec vmSpec = cloneSpec.getVmSpec();
        NetworkSpec networkSpec = cloneSpec.getNetworkSpec();
        boolean isLinkedClone = cloneSpec.isLinked();
        IMachine master = cloneSpec.getMaster();
        String flags = "";
        ImmutableList groups = ImmutableList.of();
        String group = "";
        String settingsFile = ((VirtualBoxManager)this.manager.get()).getVBox().composeMachineFilename(vmSpec.getVmName(), group, flags, this.workingDir);
        IMachine clonedMachine = ((VirtualBoxManager)this.manager.get()).getVBox().createMachine(settingsFile, vmSpec.getVmName(), (List)groups, vmSpec.getOsTypeId(), flags);
        ArrayList options = Lists.newArrayList();
        if (isLinkedClone) {
            options.add(CloneOptions.Link);
        }
        ISnapshot currentSnapshot = new TakeSnapshotIfNotAlreadyAttached(this.manager, "snapshotName", "snapshotDesc", this.logger).apply(master);
        IProgress progress = currentSnapshot.getMachine().cloneTo(clonedMachine, CloneMode.MachineState, (List)options);
        progress.waitForCompletion(Integer.valueOf(-1));
        clonedMachine.setMemorySize(Long.valueOf(cloneSpec.getVmSpec().getMemory()));
        ((VirtualBoxManager)this.manager.get()).getVBox().registerMachine(clonedMachine);
        for (NetworkInterfaceCard networkInterfaceCard : networkSpec.getNetworkInterfaceCards()) {
            new AttachNicToMachine(vmSpec.getVmName(), this.machineUtils).apply(networkInterfaceCard);
        }
        this.logger.debug("<< storing guest credentials on vm(%s) as extra data", new Object[]{clonedMachine.getName()});
        String masterUsername = master.getExtraData("guestUser");
        String masterPassword = master.getExtraData("guestPassword");
        clonedMachine.setExtraData("guestUser", masterUsername);
        clonedMachine.setExtraData("guestPassword", masterPassword);
        return clonedMachine;
    }
}

