/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.BuildVersion;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.ssh.SshClient;
import org.jclouds.virtualbox.domain.IsoSpec;
import org.jclouds.virtualbox.domain.MasterSpec;
import org.jclouds.virtualbox.domain.VmSpec;
import org.jclouds.virtualbox.functions.CreateAndRegisterMachineFromIsoIfNotAlreadyExists;
import org.jclouds.virtualbox.functions.DetachDistroMediumFromMachine;
import org.jclouds.virtualbox.functions.IMachineToNodeMetadata;
import org.jclouds.virtualbox.functions.SendScancodes;
import org.jclouds.virtualbox.functions.StringToKeyCode;
import org.jclouds.virtualbox.statements.InstallGuestAdditions;
import org.jclouds.virtualbox.util.MachineController;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IMediumAttachment;

@Singleton
public class CreateAndInstallVm
implements Function<MasterSpec, IMachine> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CreateAndRegisterMachineFromIsoIfNotAlreadyExists createAndRegisterMachineFromIsoIfNotAlreadyExists;
    private final Predicate<SshClient> sshResponds;
    private final Function<IMachine, SshClient> sshClientForIMachine;
    private final MachineUtils machineUtils;
    private final IMachineToNodeMetadata imachineToNodeMetadata;
    private final MachineController machineController;
    private final String version;
    private final String preconfigurationUrl;

    @Inject
    public CreateAndInstallVm(CreateAndRegisterMachineFromIsoIfNotAlreadyExists CreateAndRegisterMachineFromIsoIfNotAlreadyExists2, IMachineToNodeMetadata imachineToNodeMetadata, Predicate<SshClient> sshResponds, Function<IMachine, SshClient> sshClientForIMachine, MachineUtils machineUtils, MachineController machineController, @BuildVersion String version, @Named(value="jclouds.virtualbox.preconfigurationurl") String preconfigurationUrl) {
        this.createAndRegisterMachineFromIsoIfNotAlreadyExists = CreateAndRegisterMachineFromIsoIfNotAlreadyExists2;
        this.sshResponds = sshResponds;
        this.sshClientForIMachine = sshClientForIMachine;
        this.machineUtils = machineUtils;
        this.imachineToNodeMetadata = imachineToNodeMetadata;
        this.machineController = machineController;
        this.version = (String)Iterables.get((Iterable)Splitter.on((char)'-').split((CharSequence)version), (int)0);
        this.preconfigurationUrl = preconfigurationUrl;
    }

    public IMachine apply(MasterSpec masterSpec) {
        VmSpec vmSpec = masterSpec.getVmSpec();
        IsoSpec isoSpec = masterSpec.getIsoSpec();
        String masterName = vmSpec.getVmName();
        IMachine masterMachine = (IMachine)Preconditions.checkNotNull((Object)this.createAndRegisterMachineFromIsoIfNotAlreadyExists.apply(masterSpec), (Object)"master machine");
        this.machineController.ensureMachineIsLaunched(masterName);
        String installationKeySequence = isoSpec.getInstallationKeySequence().replace("PRECONFIGURATION_URL", this.preconfigurationUrl);
        this.configureOsInstallationWithKeyboardSequence(masterName, installationKeySequence);
        masterMachine.setExtraData("guestUser", masterSpec.getLoginCredentials().getUser());
        masterMachine.setExtraData("guestPassword", masterSpec.getLoginCredentials().getPassword());
        SshClient client = (SshClient)this.sshClientForIMachine.apply((Object)masterMachine);
        this.logger.debug(">> awaiting installation to finish node(%s)", new Object[]{masterName});
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        Preconditions.checkState((boolean)this.sshResponds.apply((Object)client), (String)"timed out waiting for guest %s to be accessible via ssh", (Object[])new Object[]{masterName});
        stopwatch.stop();
        this.logger.debug(String.format("Elapsed time for the OS installation: %d minutes", TimeUnit.SECONDS.convert(stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)), new Object[0]);
        NodeMetadata nodeMetadata = this.imachineToNodeMetadata.apply(masterMachine);
        this.logger.debug(">> awaiting post-installation actions on vm: %s", new Object[]{masterName});
        ListenableFuture<ExecResponse> execCleanup = this.machineUtils.runScriptOnNode(nodeMetadata, Statements.call((String)"cleanupUdevIfNeeded", (String[])new String[0]), RunScriptOptions.NONE);
        ExecResponse cleanupResponse = (ExecResponse)Futures.getUnchecked(execCleanup);
        Preconditions.checkState((cleanupResponse.getExitStatus() == 0 ? 1 : 0) != 0, (String)"post-installation actions on vm(%s) failed", (Object[])new Object[]{masterName});
        this.logger.debug(">> awaiting installation of guest additions on vm: %s", new Object[]{masterName});
        ListenableFuture<ExecResponse> execInstallGA = this.machineUtils.runScriptOnNode(nodeMetadata, new InstallGuestAdditions(vmSpec, this.version), RunScriptOptions.NONE);
        this.logger.debug(">> check installation of guest additions on vm: %s", new Object[]{masterName});
        ListenableFuture<ExecResponse> checkGAinstallation = this.machineUtils.runScriptOnNode(nodeMetadata, Statements.call((String)"checkVBoxService", (String[])new String[0]), RunScriptOptions.NONE);
        ExecResponse checkGAinstallationResponse = (ExecResponse)Futures.getUnchecked(checkGAinstallation);
        Preconditions.checkState((checkGAinstallationResponse.getExitStatus() == 0 ? 1 : 0) != 0, (String)"check installation of guest additions on vm(%s) failed", (Object[])new Object[]{masterName});
        this.machineController.ensureMachineIsShutdown(masterName);
        Iterable mediumAttachments = Iterables.filter((Iterable)masterMachine.getMediumAttachmentsOfController("IDE Controller"), (Predicate)new Predicate<IMediumAttachment>(){

            public boolean apply(IMediumAttachment in) {
                return in.getMedium() != null && in.getMedium().getDeviceType().equals((Object)DeviceType.DVD);
            }
        });
        for (IMediumAttachment iMediumAttachment : mediumAttachments) {
            this.logger.debug("<< iMedium(%s) detached from (%s)", new Object[]{iMediumAttachment.getMedium().getName(), masterMachine.getName()});
            this.machineUtils.sharedLockMachineAndApply(masterMachine.getName(), new DetachDistroMediumFromMachine(iMediumAttachment.getController(), iMediumAttachment.getPort(), iMediumAttachment.getDevice()));
        }
        return masterMachine;
    }

    private void configureOsInstallationWithKeyboardSequence(String vmName, String installationKeySequence) {
        Iterable scancodelist = Iterables.transform((Iterable)Splitter.on((String)" ").split((CharSequence)installationKeySequence), (Function)new StringToKeyCode());
        for (List scancodes : scancodelist) {
            this.machineUtils.sharedLockMachineAndApplyToSession(vmName, new SendScancodes(scancodes));
        }
    }
}

