/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.Provider;

@Singleton
public class HardcodedHostToHostNodeMetadata
implements Function<NodeMetadata, NodeMetadata> {
    private final Supplier<URI> providerSupplier;
    private final Supplier<Credentials> creds;

    @Inject
    public HardcodedHostToHostNodeMetadata(@Provider Supplier<URI> providerSupplier, @Provider Supplier<Credentials> creds) {
        this.providerSupplier = (Supplier)Preconditions.checkNotNull(providerSupplier, (Object)"endpoint to virtualbox websrvd is needed");
        this.creds = creds;
    }

    public NodeMetadata apply(NodeMetadata host) {
        Credentials currentCreds = (Credentials)Preconditions.checkNotNull((Object)this.creds.get(), (Object)"credential supplier returned null");
        String username = currentCreds.identity;
        String password = currentCreds.credential.equals("CHANGE_ME") ? "" : currentCreds.credential;
        LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder((Credentials)host.getCredentials()).user(username);
        if (!password.isEmpty()) {
            credentialsBuilder.password(password);
        }
        return NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)host).credentials(credentialsBuilder.build()).publicAddresses((Iterable)ImmutableList.of((Object)((URI)this.providerSupplier.get()).getHost())).build();
    }
}

