/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.javax.annotation.Nullable;
import org.virtualbox_4_2.IGuestOSType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.VirtualBoxManager;

public class IMachineToHardware
implements Function<IMachine, Hardware> {
    private Supplier<VirtualBoxManager> virtualBoxManager;

    @Inject
    public IMachineToHardware(Supplier<VirtualBoxManager> virtualBoxManager) {
        this.virtualBoxManager = virtualBoxManager;
    }

    public Hardware apply(@Nullable IMachine vm) {
        String osTypeId = vm.getOSTypeId();
        String vmNameWithoutPrefix = vm.getName().replace("jclouds-image-0x0-", "");
        IGuestOSType guestOSType = ((VirtualBoxManager)this.virtualBoxManager.get()).getVBox().getGuestOSType(osTypeId);
        Boolean is64Bit = guestOSType.getIs64Bit();
        HardwareBuilder hardwareBuilder = new HardwareBuilder();
        hardwareBuilder.ids(vmNameWithoutPrefix);
        hardwareBuilder.is64Bit(is64Bit.booleanValue());
        hardwareBuilder.supportsImage(ImagePredicates.idEquals((String)vmNameWithoutPrefix));
        hardwareBuilder.hypervisor("VirtualBox");
        return hardwareBuilder.build();
    }
}

