/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.javax.annotation.Nullable;
import org.virtualbox_4_2.IGuestOSType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.MachineState;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class IMachineToImage
implements Function<IMachine, Image> {
    private final Map<MachineState, Image.Status> toPortableImageStatus;
    private final Supplier<VirtualBoxManager> virtualboxManager;
    private final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    public IMachineToImage(Map<MachineState, Image.Status> toPortableImageStatus, Supplier<VirtualBoxManager> virtualboxManager, Map<OsFamily, Map<String, String>> osVersionMap) {
        this.toPortableImageStatus = (Map)Preconditions.checkNotNull(toPortableImageStatus, (Object)"toPortableImageStatus");
        this.virtualboxManager = (Supplier)Preconditions.checkNotNull(virtualboxManager, (Object)"virtualboxManager");
        this.osVersionMap = (Map)Preconditions.checkNotNull(osVersionMap, (Object)"osVersionMap");
    }

    public Image apply(@Nullable IMachine from) {
        if (from == null) {
            return null;
        }
        IGuestOSType guestOSType = ((VirtualBoxManager)this.virtualboxManager.get()).getVBox().getGuestOSType(from.getOSTypeId());
        OsFamily family = ComputeServiceUtils.parseOsFamilyOrUnrecognized((String)guestOSType.getDescription());
        String version = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)family, (String)guestOSType.getDescription(), this.osVersionMap);
        OperatingSystem os = OperatingSystem.builder().description(guestOSType.getDescription()).family(family).version(version).is64Bit(guestOSType.getIs64Bit().booleanValue()).build();
        return new ImageBuilder().id(from.getName().substring("jclouds-image-0x0-".length(), from.getName().length())).name(from.getName()).description(from.getDescription()).operatingSystem(os).status(this.toPortableImageStatus.get(from.getState())).build();
    }
}

