/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.options.RunScriptOptions;
import org.virtualbox_4_2.IGuestOSType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.VirtualBoxManager;

public class IMachineToIpAddress
implements Function<IMachine, String> {
    private VirtualBoxManager manager;
    private ComputeService computeService;

    public IMachineToIpAddress(VirtualBoxManager manager, ComputeService computeService) {
        this.manager = manager;
        this.computeService = computeService;
    }

    public String apply(IMachine machine) {
        String macAddress = machine.getNetworkAdapter(Long.valueOf(0L)).getMACAddress();
        int offset = 0;
        int step = 2;
        for (int j = 1; j <= 5; ++j) {
            macAddress = new StringBuilder(macAddress).insert(j * step + offset, ":").toString().toLowerCase();
            ++offset;
        }
        String simplifiedMacAddressOfClonedVM = macAddress;
        String hostId = System.getProperty("jclouds.virtualbox.hostid");
        IMachine hostMachine = this.manager.getVBox().findMachine(hostId);
        if (this.isOSX(hostMachine)) {
            if (simplifiedMacAddressOfClonedVM.contains("00")) {
                simplifiedMacAddressOfClonedVM = new StringBuilder(simplifiedMacAddressOfClonedVM).delete(simplifiedMacAddressOfClonedVM.indexOf("00"), simplifiedMacAddressOfClonedVM.indexOf("00") + 1).toString();
            }
            if (simplifiedMacAddressOfClonedVM.contains("0") && simplifiedMacAddressOfClonedVM.indexOf("0") + 1 != 58 && simplifiedMacAddressOfClonedVM.indexOf("0") - 1 != 58) {
                simplifiedMacAddressOfClonedVM = new StringBuilder(simplifiedMacAddressOfClonedVM).delete(simplifiedMacAddressOfClonedVM.indexOf("0"), simplifiedMacAddressOfClonedVM.indexOf("0") + 1).toString();
            }
        }
        ExecResponse execResponse = this.runScriptOnNode(hostId, "for i in {1..254} ; do ping -c 1 -t 1 192.168.2.$i & done", RunScriptOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false));
        System.out.println(execResponse);
        String arpLine = this.runScriptOnNode(hostId, "arp -an | grep " + simplifiedMacAddressOfClonedVM, RunScriptOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false)).getOutput();
        String ipAddress = arpLine.substring(arpLine.indexOf("(") + 1, arpLine.indexOf(")"));
        System.out.println("IP address " + ipAddress);
        return ipAddress;
    }

    private ExecResponse runScriptOnNode(String nodeId, String command, RunScriptOptions options) {
        return this.computeService.runScriptOnNode(nodeId, command, options);
    }

    protected boolean isOSX(IMachine machine) {
        String osTypeId = machine.getOSTypeId();
        IGuestOSType guestOSType = this.manager.getVBox().getGuestOSType(osTypeId);
        return guestOSType.getFamilyDescription().equals("Other");
    }
}

