/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.util.NetworkUtils;
import org.virtualbox_4_2.IGuestOSType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.INetworkAdapter;
import org.virtualbox_4_2.MachineState;
import org.virtualbox_4_2.NetworkAttachmentType;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class IMachineToNodeMetadata
implements Function<IMachine, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<VirtualBoxManager> virtualboxManager;
    private final Map<MachineState, NodeMetadata.Status> toPortableNodeStatus;
    private final NetworkUtils networkUtils;
    private final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    public IMachineToNodeMetadata(Supplier<VirtualBoxManager> virtualboxManager, Map<MachineState, NodeMetadata.Status> toPortableNodeStatus, NetworkUtils networkUtils, Map<OsFamily, Map<String, String>> osVersionMap) {
        this.virtualboxManager = (Supplier)Preconditions.checkNotNull(virtualboxManager, (Object)"virtualboxManager");
        this.toPortableNodeStatus = (Map)Preconditions.checkNotNull(toPortableNodeStatus, (Object)"toPortableNodeStatus");
        this.networkUtils = (NetworkUtils)Preconditions.checkNotNull((Object)networkUtils, (Object)"networkUtils");
        this.osVersionMap = (Map)Preconditions.checkNotNull(osVersionMap, (Object)"osVersionMap");
    }

    public NodeMetadata apply(@Nullable IMachine vm) {
        String group = "";
        String name = "";
        String[] encodedInVmName = vm.getName().split("-0x0-");
        if (vm.getName().startsWith("jclouds-node-0x0-")) {
            group = encodedInVmName[2];
            name = encodedInVmName[3];
        } else {
            name = encodedInVmName[1];
        }
        NodeMetadataBuilder nodeMetadataBuilder = new NodeMetadataBuilder();
        nodeMetadataBuilder.name(name).ids(vm.getName()).group(group);
        LocationBuilder locationBuilder = new LocationBuilder();
        locationBuilder.description("");
        locationBuilder.id("");
        locationBuilder.scope(LocationScope.HOST);
        nodeMetadataBuilder.location(locationBuilder.build());
        nodeMetadataBuilder.hostname(vm.getName());
        MachineState vmState = vm.getState();
        NodeMetadata.Status nodeState = this.toPortableNodeStatus.get(vmState);
        if (nodeState == null) {
            nodeState = NodeMetadata.Status.UNRECOGNIZED;
        }
        nodeMetadataBuilder.status(nodeState);
        nodeMetadataBuilder = this.getIpAddresses(vm, nodeMetadataBuilder);
        IGuestOSType guestOSType = ((VirtualBoxManager)this.virtualboxManager.get()).getVBox().getGuestOSType(vm.getOSTypeId());
        OsFamily family = ComputeServiceUtils.parseOsFamilyOrUnrecognized((String)guestOSType.getDescription());
        String version = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)family, (String)guestOSType.getDescription(), this.osVersionMap);
        OperatingSystem os = OperatingSystem.builder().description(guestOSType.getDescription()).family(family).version(version).is64Bit(guestOSType.getIs64Bit().booleanValue()).build();
        nodeMetadataBuilder.operatingSystem(os);
        String guestOsUser = vm.getExtraData("guestUser");
        String guestOsPassword = vm.getExtraData("guestPassword");
        nodeMetadataBuilder.credentials(LoginCredentials.builder().user(guestOsUser).password(guestOsPassword).authenticateSudo(true).build());
        return nodeMetadataBuilder.build();
    }

    private NodeMetadataBuilder getIpAddresses(IMachine vm, NodeMetadataBuilder nodeMetadataBuilder) {
        ArrayList publicIpAddresses = Lists.newArrayList();
        ArrayList privateIpAddresses = Lists.newArrayList();
        for (long slot = 0L; slot < 4L; ++slot) {
            String clientIpAddress;
            INetworkAdapter adapter = vm.getNetworkAdapter(Long.valueOf(slot));
            if (adapter == null) continue;
            if (adapter.getAttachmentType() == NetworkAttachmentType.NAT) {
                String hostIP = adapter.getNATEngine().getHostIP();
                if (!hostIP.isEmpty()) {
                    publicIpAddresses.add(hostIP);
                }
                for (String nameProtocolnumberAddressInboudportGuestTargetport : adapter.getNATEngine().getRedirects()) {
                    Iterable stuff = Splitter.on((char)',').split((CharSequence)nameProtocolnumberAddressInboudportGuestTargetport);
                    String protocolNumber = (String)Iterables.get((Iterable)stuff, (int)1);
                    String hostAddress = (String)Iterables.get((Iterable)stuff, (int)2);
                    String inboundPort = (String)Iterables.get((Iterable)stuff, (int)3);
                    String targetPort = (String)Iterables.get((Iterable)stuff, (int)5);
                    if (!"1".equals(protocolNumber) || !"22".equals(targetPort)) continue;
                    int inPort = Integer.parseInt(inboundPort);
                    publicIpAddresses.add(hostAddress);
                    nodeMetadataBuilder.loginPort(inPort);
                }
                continue;
            }
            if (adapter.getAttachmentType() == NetworkAttachmentType.Bridged) {
                clientIpAddress = this.networkUtils.getIpAddressFromNicSlot(vm.getName(), adapter.getSlot());
                privateIpAddresses.add(clientIpAddress);
                continue;
            }
            if (adapter.getAttachmentType() != NetworkAttachmentType.HostOnly) continue;
            clientIpAddress = this.networkUtils.getValidHostOnlyIpFromVm(vm.getName());
            publicIpAddresses.add(clientIpAddress);
        }
        nodeMetadataBuilder.publicAddresses((Iterable)publicIpAddresses);
        nodeMetadataBuilder.privateAddresses((Iterable)publicIpAddresses);
        return nodeMetadataBuilder;
    }
}

