/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshClient;
import org.jclouds.virtualbox.util.NetworkUtils;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.INetworkAdapter;
import org.virtualbox_4_2.NetworkAttachmentType;

@Singleton
public class IMachineToSshClient
implements Function<IMachine, SshClient> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final SshClient.Factory sshClientFactory;
    private final NetworkUtils networkUtils;

    @Inject
    public IMachineToSshClient(SshClient.Factory sshClientFactory, NetworkUtils networkUtils) {
        this.sshClientFactory = sshClientFactory;
        this.networkUtils = networkUtils;
    }

    public SshClient apply(IMachine vm) {
        String sshPort = "22";
        String guestIdentity = vm.getExtraData("guestUser");
        String guestCredential = vm.getExtraData("guestPassword");
        LoginCredentials loginCredentials = LoginCredentials.builder().user(guestIdentity).password(guestCredential).authenticateSudo(true).build();
        String clientIpAddress = null;
        for (long nicSlot = 0L; nicSlot < 4L && Strings.isNullOrEmpty(clientIpAddress); ++nicSlot) {
            INetworkAdapter networkAdapter = vm.getNetworkAdapter(Long.valueOf(nicSlot));
            if (networkAdapter.getAttachmentType().equals((Object)NetworkAttachmentType.NAT)) {
                for (String nameProtocolnumberAddressInboudportGuestTargetport : networkAdapter.getNATEngine().getRedirects()) {
                    Iterable stuff = Splitter.on((char)',').split((CharSequence)nameProtocolnumberAddressInboudportGuestTargetport);
                    String protocolNumber = (String)Iterables.get((Iterable)stuff, (int)1);
                    String hostAddress = (String)Iterables.get((Iterable)stuff, (int)2);
                    String inboundPort = (String)Iterables.get((Iterable)stuff, (int)3);
                    String targetPort = (String)Iterables.get((Iterable)stuff, (int)5);
                    if (!"1".equals(protocolNumber) || !"22".equals(targetPort)) continue;
                    clientIpAddress = hostAddress;
                    sshPort = inboundPort;
                }
                continue;
            }
            if (networkAdapter.getAttachmentType().equals((Object)NetworkAttachmentType.Bridged)) {
                clientIpAddress = this.networkUtils.getIpAddressFromNicSlot(vm.getName(), networkAdapter.getSlot());
                continue;
            }
            if (!networkAdapter.getAttachmentType().equals((Object)NetworkAttachmentType.HostOnly)) continue;
            clientIpAddress = this.networkUtils.getValidHostOnlyIpFromVm(vm.getName());
        }
        return this.sshClientFactory.create(HostAndPort.fromParts(clientIpAddress, (int)Integer.parseInt(sshPort)), loginCredentials);
    }
}

