/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.domain.HardDisk;
import org.jclouds.virtualbox.domain.StorageController;
import org.jclouds.virtualbox.domain.VmSpec;
import org.virtualbox_4_2.CleanupMode;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IMedium;
import org.virtualbox_4_2.IMediumAttachment;
import org.virtualbox_4_2.IStorageController;

public class IMachineToVmSpec
implements Function<IMachine, VmSpec> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public VmSpec apply(IMachine machine) {
        List<StorageController> controllers = this.buildControllers(machine);
        VmSpec.Builder vmSpecBuilder = VmSpec.builder();
        vmSpecBuilder.id(machine.getId()).name(machine.getName()).memoryMB(machine.getMemorySize().intValue()).osTypeId(machine.getOSTypeId()).forceOverwrite(true).cleanUpMode(CleanupMode.Full);
        for (StorageController storageController : controllers) {
            vmSpecBuilder.controller(storageController);
        }
        return vmSpecBuilder.build();
    }

    private List<StorageController> buildControllers(IMachine machine) {
        ArrayList controllers = Lists.newArrayList();
        for (IStorageController iStorageController : machine.getStorageControllers()) {
            StorageController.Builder storageControllerBuilder = StorageController.builder();
            for (IMediumAttachment iMediumAttachment : machine.getMediumAttachmentsOfController(iStorageController.getName())) {
                IMedium iMedium = iMediumAttachment.getMedium();
                if (iMedium == null) continue;
                if (iMedium.getDeviceType().equals((Object)DeviceType.HardDisk)) {
                    storageControllerBuilder.attachHardDisk(HardDisk.builder().diskpath(iMedium.getLocation()).autoDelete(true).controllerPort(iMediumAttachment.getPort()).deviceSlot(iMediumAttachment.getDevice()).build());
                    continue;
                }
                if (!iMedium.getDeviceType().equals((Object)DeviceType.DVD)) continue;
                storageControllerBuilder.attachISO(iMediumAttachment.getPort(), iMediumAttachment.getDevice(), iMedium.getLocation());
            }
            controllers.add(storageControllerBuilder.name(iStorageController.getName()).bus(iStorageController.getBus()).build());
        }
        return controllers;
    }
}

