/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.util.MachineNameOrIdAndNicSlot;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class IpAddressesLoadingCache
extends AbstractLoadingCache<MachineNameOrIdAndNicSlot, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Map<MachineNameOrIdAndNicSlot, String> masters = Maps.newHashMap();
    private final Supplier<VirtualBoxManager> manager;

    @Inject
    public IpAddressesLoadingCache(Supplier<VirtualBoxManager> manager) {
        this.manager = (Supplier)Preconditions.checkNotNull(manager, (Object)"vboxmanager");
    }

    public synchronized String get(MachineNameOrIdAndNicSlot machineNameOrIdAndNicPort) throws ExecutionException {
        if (this.masters.containsKey(machineNameOrIdAndNicPort)) {
            return this.masters.get(machineNameOrIdAndNicPort);
        }
        String query = String.format("/VirtualBox/GuestInfo/Net/%s/V4/IP", machineNameOrIdAndNicPort.getSlotText());
        String ipAddress = Strings.nullToEmpty((String)((VirtualBoxManager)this.manager.get()).getVBox().findMachine(machineNameOrIdAndNicPort.getMachineNameOrId()).getGuestPropertyValue(query));
        if (!ipAddress.isEmpty()) {
            this.logger.debug("<< vm(%s) has IP address(%s) at slot(%s)", new Object[]{machineNameOrIdAndNicPort.getMachineNameOrId(), ipAddress, machineNameOrIdAndNicPort.getSlotText()});
        }
        this.masters.put(machineNameOrIdAndNicPort, ipAddress);
        return ipAddress;
    }

    public String getIfPresent(Object key) {
        return this.masters.get((MachineNameOrIdAndNicSlot)key);
    }

    public void invalidate(Object key) {
        this.masters.remove(key);
    }
}

