/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;
import org.jclouds.virtualbox.config.VirtualBoxComputeServiceContextModule;
import org.jclouds.virtualbox.domain.CloneSpec;
import org.jclouds.virtualbox.domain.Master;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;
import org.jclouds.virtualbox.domain.NetworkSpec;
import org.jclouds.virtualbox.domain.NodeSpec;
import org.jclouds.virtualbox.domain.VmSpec;
import org.jclouds.virtualbox.statements.DeleteGShadowLock;
import org.jclouds.virtualbox.statements.PasswordlessSudo;
import org.jclouds.virtualbox.util.MachineController;
import org.jclouds.virtualbox.util.MachineUtils;
import org.jclouds.virtualbox.util.NetworkUtils;
import org.virtualbox_4_2.CleanupMode;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISession;
import org.virtualbox_4_2.LockType;
import org.virtualbox_4_2.NetworkAttachmentType;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class NodeCreator
implements Function<NodeSpec, ComputeServiceAdapter.NodeAndInitialCredentials<IMachine>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<VirtualBoxManager> manager;
    private final Function<CloneSpec, IMachine> cloner;
    private final MachineUtils machineUtils;
    private final MachineController machineController;
    private final NetworkUtils networkUtils;
    private final int ram;
    private final String workingDir;

    @Inject
    public NodeCreator(Supplier<VirtualBoxManager> manager, Function<CloneSpec, IMachine> cloner, MachineUtils machineUtils, MachineController machineController, NetworkUtils networkUtils, @Named(value="jclouds.virtualbox.guest.memory") String ram, @Named(value="jclouds.virtualbox.workingdir") String workingDir) {
        this.manager = (Supplier)Preconditions.checkNotNull(manager, (Object)"manager");
        this.cloner = (Function)Preconditions.checkNotNull(cloner, (Object)"cloner");
        this.networkUtils = (NetworkUtils)Preconditions.checkNotNull((Object)networkUtils, (Object)"networkUtils");
        this.machineUtils = (MachineUtils)Preconditions.checkNotNull((Object)machineUtils, (Object)"machineUtils");
        this.machineController = (MachineController)Preconditions.checkNotNull((Object)machineController, (Object)"machineController");
        this.ram = (Integer)Preconditions.checkNotNull((Object)Integer.valueOf(ram), (Object)"ram");
        this.workingDir = (String)Preconditions.checkNotNull((Object)workingDir, (Object)"workingDir");
    }

    public synchronized ComputeServiceAdapter.NodeAndInitialCredentials<IMachine> apply(NodeSpec nodeSpec) {
        Preconditions.checkNotNull((Object)nodeSpec, (Object)"NodeSpec");
        Master master = (Master)Preconditions.checkNotNull((Object)nodeSpec.getMaster(), (Object)"Master");
        IMachine masterMachine = master.getMachine();
        String guestOsUser = masterMachine.getExtraData("guestUser");
        String guestOsPassword = masterMachine.getExtraData("guestPassword");
        this.cleanUpMaster(master);
        CloneSpec cloneSpec = this.configureCloneSpec(nodeSpec, guestOsUser, guestOsPassword);
        IMachine clone = (IMachine)this.cloner.apply((Object)cloneSpec);
        String cloneName = cloneSpec.getVmSpec().getVmName();
        this.logger.debug("<< cloned a vm(%s) from master(%s)", new Object[]{cloneName, nodeSpec.getMaster().getMachine().getName()});
        this.machineController.ensureMachineIsLaunched(cloneName);
        this.logger.debug("<< cloned vm(%s) is up and running", new Object[]{cloneName});
        this.reconfigureNetworkInterfaces(masterMachine, guestOsUser, guestOsPassword, cloneSpec.getNetworkSpec(), clone);
        this.postConfigurations(clone, guestOsUser, guestOsPassword);
        LoginCredentials credentials = LoginCredentials.builder().user(guestOsUser).password(guestOsPassword).authenticateSudo(true).build();
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)clone, cloneName, credentials);
    }

    private void reconfigureNetworkInterfaces(IMachine masterMachine, String guestOsUser, String guestOsPassword, NetworkSpec networkSpec, IMachine clone) {
        this.reconfigureHostOnlyInterfaceIfNeeded(guestOsUser, guestOsPassword, clone.getName(), masterMachine.getOSTypeId());
        this.logger.debug("<< reconfigured hostOnly interface of node(%s)", new Object[]{clone.getName()});
        this.reconfigureNatInterfaceIfNeeded(guestOsUser, guestOsPassword, clone.getOSTypeId(), clone, networkSpec);
        this.logger.debug("<< reconfigured NAT interface of node(%s)", new Object[]{clone.getName()});
    }

    private void postConfigurations(IMachine clone, String guestOsUser, String guestOsPassword) {
        NodeMetadata partialNodeMetadata = this.buildPartialNodeMetadata(clone, guestOsUser, guestOsPassword);
        this.machineUtils.runScriptOnNode(partialNodeMetadata, new DeleteGShadowLock(), RunScriptOptions.NONE);
        this.machineUtils.runScriptOnNode(partialNodeMetadata, new PasswordlessSudo(partialNodeMetadata.getCredentials().identity), RunScriptOptions.Builder.runAsRoot((boolean)true));
    }

    private CloneSpec configureCloneSpec(NodeSpec nodeSpec, String guestOsUser, String guestOsPassword) {
        String cloneName = this.generateCloneName(nodeSpec);
        VmSpec cloneVmSpec = VmSpec.builder().id(cloneName).name(cloneName).memoryMB(this.ram).osTypeId(nodeSpec.getMaster().getMachine().getOSTypeId()).guestUser(guestOsUser).guestPassword(guestOsPassword).cleanUpMode(CleanupMode.Full).forceOverwrite(true).build();
        NetworkSpec networkSpec = this.networkUtils.createNetworkSpecWhenVboxIsLocalhost();
        return CloneSpec.builder().linked(true).master(nodeSpec.getMaster().getMachine()).network(networkSpec).vm(cloneVmSpec).build();
    }

    private void cleanUpMaster(Master master) {
        this.deleteExistingSnapshot(master);
    }

    private void reconfigureHostOnlyInterfaceIfNeeded(String username, String password, String vmName, String osTypeId) {
        String scriptName = "hostOnly";
        if (osTypeId.contains("RedHat")) {
            File scriptFile = this.copyScriptToWorkingDir("redHatAndDerivatives", "hostOnly");
            this.copyToNodeAndExecScript(username, password, vmName, scriptFile);
        }
    }

    private void reconfigureNatInterfaceIfNeeded(String guestOsUser, String guestOsPassword, String osTypeId, IMachine clone, NetworkSpec networkSpec) {
        String scriptName = "nat";
        String folder = "redHatAndDerivatives";
        if (osTypeId.contains("RedHat")) {
            File scriptFile = this.copyScriptToWorkingDir("redHatAndDerivatives", "nat");
            this.copyToNodeAndExecScript(guestOsUser, guestOsPassword, clone.getName(), scriptFile);
        } else if (osTypeId.contains("Ubuntu") || osTypeId.contains("Debian")) {
            NodeMetadata partialNodeMetadata = this.buildPartialNodeMetadata(clone, guestOsUser, guestOsPassword);
            Optional optionalNatIfaceCard = Iterables.tryFind(networkSpec.getNetworkInterfaceCards(), (Predicate)new Predicate<NetworkInterfaceCard>(){

                public boolean apply(NetworkInterfaceCard nic) {
                    return nic.getNetworkAdapter().getNetworkAttachmentType().equals((Object)NetworkAttachmentType.NAT);
                }
            });
            Preconditions.checkState((boolean)this.networkUtils.enableNetworkInterface(partialNodeMetadata, (NetworkInterfaceCard)optionalNatIfaceCard.get()), (String)"cannot enable NAT Interface on vm(%s)", (Object[])new Object[]{clone.getName()});
        }
    }

    private File copyScriptToWorkingDir(String folder, String scriptName) {
        File scriptFile = new File(this.workingDir + "/conf/" + "/" + folder + "/" + scriptName);
        scriptFile.getParentFile().mkdirs();
        if (!scriptFile.exists()) {
            try {
                Files.write((CharSequence)Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/" + folder + "/" + scriptName)), (File)scriptFile, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return scriptFile;
    }

    private void copyToNodeAndExecScript(final String username, final String password, String vmName, final File scriptFile) {
        this.machineUtils.sharedLockMachineAndApplyToSession(vmName, new Function<ISession, Void>(){

            public Void apply(ISession session) {
                String scriptName = scriptFile.getName();
                ((VirtualBoxManager)NodeCreator.this.manager.get()).getSessionObject().getConsole().getGuest().createSession(username, password, null, null).copyTo(scriptFile.getAbsolutePath(), "/tmp/" + scriptName, null);
                ((VirtualBoxManager)NodeCreator.this.manager.get()).getSessionObject().getConsole().getGuest().createSession(username, password, null, null).processCreate("/bin/chmod", (List)ImmutableList.of((Object)"777", (Object)("/tmp/" + scriptName)), null, null, Long.valueOf(5000L));
                ((VirtualBoxManager)NodeCreator.this.manager.get()).getSessionObject().getConsole().getGuest().createSession(username, password, null, null).processCreate("/bin/sh", (List)ImmutableList.of((Object)("/tmp/" + scriptName)), null, null, Long.valueOf(5000L));
                return null;
            }
        });
    }

    private String generateCloneName(NodeSpec nodeSpec) {
        String masterNameWithoutPrefix = nodeSpec.getMaster().getMachine().getName().replace("jclouds-image-0x0-", "");
        return "jclouds-node-0x0-" + masterNameWithoutPrefix + "-0x0-" + nodeSpec.getTag() + "-0x0-" + nodeSpec.getName();
    }

    private void deleteExistingSnapshot(Master master) {
        if (master.getMachine().getCurrentSnapshot() != null) {
            try {
                ISession session = ((VirtualBoxManager)this.manager.get()).getSessionObject();
                master.getMachine().lockMachine(session, LockType.Write);
                IProgress progress = session.getConsole().deleteSnapshot(master.getMachine().getCurrentSnapshot().getId());
                progress.waitForCompletion(Integer.valueOf(-1));
                session.unlockMachine();
            }
            catch (Exception e) {
                throw new RuntimeException("error opening vbox machine session: " + e.getMessage(), e);
            }
            this.logger.debug("<< deleted an existing snapshot of vm(%s)", new Object[]{master.getMachine().getName()});
        }
    }

    private NodeMetadata buildPartialNodeMetadata(IMachine clone, String guestOsUser, String guestOsPassword) {
        NodeMetadataBuilder nodeMetadataBuilder = new NodeMetadataBuilder();
        nodeMetadataBuilder.id(clone.getName());
        nodeMetadataBuilder.status(VirtualBoxComputeServiceContextModule.toPortableNodeStatus.get(clone.getState()));
        nodeMetadataBuilder.publicAddresses((Iterable)ImmutableSet.of((Object)this.networkUtils.getValidHostOnlyIpFromVm(clone.getName())));
        nodeMetadataBuilder.credentials(LoginCredentials.builder().user(guestOsUser).password(guestOsPassword).authenticateSudo(true).build());
        return nodeMetadataBuilder.build();
    }
}

