/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.virtualbox.domain.BridgedIf;
import org.jclouds.virtualbox.functions.BridgedIfStringToBridgedIf;

public class RetrieveActiveBridgedInterfaces
implements Function<NodeMetadata, List<BridgedIf>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final RunScriptOnNode.Factory runScriptOnNodeFactory;

    @Inject
    public RetrieveActiveBridgedInterfaces(RunScriptOnNode.Factory runScriptOnNodeFactory) {
        this.runScriptOnNodeFactory = (RunScriptOnNode.Factory)Preconditions.checkNotNull((Object)runScriptOnNodeFactory, (Object)"runScriptOnNodeFactory");
    }

    public List<BridgedIf> apply(NodeMetadata host) {
        Statement command = Statements.exec((String)"VBoxManage list bridgedifs");
        String bridgedIfBlocks = this.runScriptOnNodeFactory.create(host, command, RunScriptOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false)).init().call().getOutput();
        List<BridgedIf> bridgedInterfaces = RetrieveActiveBridgedInterfaces.retrieveBridgedInterfaceNames(bridgedIfBlocks);
        Preconditions.checkNotNull(bridgedInterfaces);
        ArrayList activeNetworkInterfaces = Lists.newArrayList();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface inet : Collections.list(nets)) {
                Iterable filteredBridgedInterface = Iterables.filter(bridgedInterfaces, (Predicate)new IsActiveBridgedInterface(inet));
                Iterables.addAll((Collection)activeNetworkInterfaces, (Iterable)filteredBridgedInterface);
            }
        }
        catch (SocketException e) {
            this.logger.error((Throwable)e, "Problem in listing network interfaces.", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        return activeNetworkInterfaces;
    }

    protected static List<BridgedIf> retrieveBridgedInterfaceNames(String bridgedIfBlocks) {
        ArrayList bridgedInterfaces = Lists.newArrayList();
        for (String bridgedIfBlock : Splitter.on((Pattern)Pattern.compile("(?m)^[ \t]*\r?\n")).split((CharSequence)bridgedIfBlocks)) {
            if (bridgedIfBlock.isEmpty()) continue;
            bridgedInterfaces.add(new BridgedIfStringToBridgedIf().apply(bridgedIfBlock));
        }
        return bridgedInterfaces;
    }

    private class IsActiveBridgedInterface
    implements Predicate<BridgedIf> {
        private NetworkInterface networkInterface;

        public IsActiveBridgedInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
        }

        public boolean apply(BridgedIf bridgedInterface) {
            try {
                return bridgedInterface.getName().startsWith(this.networkInterface.getDisplayName()) && bridgedInterface.getStatus().equals("Up") && this.networkInterface.isUp() && !this.networkInterface.isLoopback();
            }
            catch (SocketException e) {
                RetrieveActiveBridgedInterfaces.this.logger.error((Throwable)e, "Problem in listing network interfaces.", new Object[0]);
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

