/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.settings.KeyboardScancodes;
import org.virtualbox_4_2.ISession;

class SendScancodes
implements Function<ISession, Void> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private static final int MAX_SIZE = 30;
    private final List<Integer> scancodes;

    public SendScancodes(List<Integer> scancodes) {
        this.scancodes = scancodes;
    }

    public Void apply(ISession iSession) {
        for (List maxOrLess : Lists.partition(this.scancodes, (int)30)) {
            long codesSent = iSession.getConsole().getKeyboard().putScancodes(maxOrLess);
            this.logger.debug("List of scancodes sent: ", new Object[]{maxOrLess});
            assert (codesSent == (long)maxOrLess.size());
            if (Iterables.any((Iterable)maxOrLess, (Predicate)Predicates.in((Collection)KeyboardScancodes.SPECIAL_KEYBOARD_BUTTON_MAP_LIST.values()))) {
                Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            Uninterruptibles.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public String toString() {
        return "sendScancodes(" + this.scancodes + ")";
    }
}

