/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.jclouds.logging.Logger;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISession;
import org.virtualbox_4_2.ISnapshot;
import org.virtualbox_4_2.MachineState;
import org.virtualbox_4_2.VirtualBoxManager;

public class TakeSnapshotIfNotAlreadyAttached
implements Function<IMachine, ISnapshot> {
    private Supplier<VirtualBoxManager> manager;
    private String snapshotName;
    private String snapshotDesc;
    private Logger logger;

    public TakeSnapshotIfNotAlreadyAttached(Supplier<VirtualBoxManager> manager, String snapshotName, String snapshotDesc, Logger logger) {
        this.manager = manager;
        this.snapshotName = snapshotName;
        this.snapshotDesc = snapshotDesc;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISnapshot apply(IMachine machine) {
        ISession session = null;
        ISnapshot snap = machine.getCurrentSnapshot();
        if (snap == null) {
            try {
                session = ((VirtualBoxManager)this.manager.get()).openMachineSession(machine);
                int retries = 10;
                while (true) {
                    try {
                        boolean paused = false;
                        if (machine.getState() == MachineState.Running) {
                            session.getConsole().pause();
                            paused = true;
                        }
                        IProgress progress = session.getConsole().takeSnapshot(this.snapshotName, this.snapshotDesc);
                        progress.waitForCompletion(Integer.valueOf(-1));
                        if (paused) {
                            session.getConsole().resume();
                        }
                        snap = machine.getCurrentSnapshot();
                        this.logger.debug("<< snapshot(%s) with description(%s) taken from master(%s)", new Object[]{this.snapshotName, this.snapshotDesc, machine.getName()});
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("VirtualBox error: The object is not ready") || e.getMessage().contains("This machine does not have any snapshots")) {
                            if (--retries == 0) {
                                this.logger.error((Throwable)e, "Problem creating snapshot (too many retries) %s (description: %s) from machine %s", new Object[]{this.snapshotName, this.snapshotDesc, machine.getName()});
                                throw Throwables.propagate((Throwable)e);
                            }
                            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                            continue;
                        }
                        this.logger.error((Throwable)e, "Problem creating snapshot %s (description: %s) from machine %s", new Object[]{this.snapshotName, this.snapshotDesc, machine.getName()});
                        throw Throwables.propagate((Throwable)e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
            finally {
                if (session != null) {
                    ((VirtualBoxManager)this.manager.get()).closeMachineSession(session);
                }
            }
        }
        return snap;
    }
}

