/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions.admin;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.virtualbox.domain.YamlImage;
import org.jclouds.virtualbox.functions.YamlImagesFromFileConfig;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Singleton
public class ImagesToYamlImagesFromYamlDescriptor
implements Supplier<Map<Image, YamlImage>> {
    private String yamlDescriptor;

    @Inject
    public ImagesToYamlImagesFromYamlDescriptor(YamlImagesFromFileConfig yamlDescriptorSupplier) {
        this.yamlDescriptor = yamlDescriptorSupplier.get();
        Preconditions.checkNotNull((Object)this.yamlDescriptor, (Object)"yaml descriptor");
        Preconditions.checkState((!this.yamlDescriptor.equals("") ? 1 : 0) != 0, (Object)"yaml descriptor is empty");
    }

    public Map<Image, YamlImage> get() {
        Constructor constructor = new Constructor(Config.class);
        TypeDescription imageDesc = new TypeDescription(YamlImage.class);
        imageDesc.putListPropertyType("images", String.class);
        constructor.addTypeDescription(imageDesc);
        Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
        Config config = (Config)yaml.load(this.yamlDescriptor);
        Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"missing config: class");
        Preconditions.checkState((config.images != null ? 1 : 0) != 0, (Object)"missing images: collection");
        LinkedHashMap backingMap = Maps.newLinkedHashMap();
        for (YamlImage yamlImage : config.images) {
            backingMap.put(YamlImage.toImage.apply((Object)yamlImage), yamlImage);
        }
        return backingMap;
    }

    public static class Config {
        public List<YamlImage> images;
    }
}

