/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions.admin;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.domain.ErrorCode;
import org.jclouds.virtualbox.domain.StorageController;
import org.jclouds.virtualbox.domain.VmSpec;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IMedium;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.VBoxException;

@Singleton
public class UnregisterMachineIfExistsAndDeleteItsMedia
implements Function<IMachine, Void> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final VmSpec vmSpec;

    public UnregisterMachineIfExistsAndDeleteItsMedia(VmSpec vmSpec) {
        this.vmSpec = vmSpec;
    }

    public Void apply(IMachine machine) {
        Object mediaToBeDeleted = ImmutableList.of();
        try {
            mediaToBeDeleted = machine.unregister(this.vmSpec.getCleanupMode());
        }
        catch (VBoxException e) {
            ErrorCode errorCode = ErrorCode.valueOf(e);
            switch (errorCode) {
                case VBOX_E_OBJECT_NOT_FOUND: {
                    this.logger.debug("Machine %s does not exists, cannot unregister", new Object[]{this.vmSpec.getVmName()});
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        ArrayList filteredMediaToBeDeleted = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)mediaToBeDeleted, (Predicate)new AutoDeleteHardDiskPredicate(this.vmSpec)), (Function)new DeleteChildrenOfMedium()));
        if (!filteredMediaToBeDeleted.isEmpty()) {
            try {
                IProgress deletion = machine.delete((List)filteredMediaToBeDeleted);
                deletion.waitForCompletion(Integer.valueOf(-1));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "Problem in deleting the media attached to %s", new Object[]{machine.getName()});
                Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    private static class DeleteChildrenOfMedium
    implements Function<IMedium, IMedium> {
        private DeleteChildrenOfMedium() {
        }

        public IMedium apply(IMedium medium) {
            Preconditions.checkNotNull((Object)medium.getChildren());
            if (medium.getDeviceType().equals((Object)DeviceType.HardDisk)) {
                for (IMedium child : medium.getChildren()) {
                    IProgress deletion = child.deleteStorage();
                    deletion.waitForCompletion(Integer.valueOf(-1));
                }
            }
            return medium;
        }
    }

    private static class AutoDeleteHardDiskPredicate
    implements Predicate<IMedium> {
        private VmSpec vmSpec;

        public AutoDeleteHardDiskPredicate(VmSpec vmSpec) {
            this.vmSpec = vmSpec;
        }

        public boolean apply(IMedium medium) {
            for (StorageController controller : this.vmSpec.getControllers()) {
                if (!controller.getHardDisk(medium.getName()).isAutoDelete()) continue;
                return true;
            }
            return false;
        }
    }
}

