/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions.admin;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.domain.ErrorCode;
import org.virtualbox_4_2.CleanupMode;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IMedium;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.VBoxException;

@Singleton
public class UnregisterMachineIfExistsAndForceDeleteItsMedia
implements Function<IMachine, Void> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public Void apply(IMachine machine) {
        Object mediaToBeDeleted = ImmutableList.of();
        try {
            mediaToBeDeleted = machine.unregister(CleanupMode.Full);
        }
        catch (VBoxException e) {
            ErrorCode errorCode = ErrorCode.valueOf(e);
            switch (errorCode) {
                case VBOX_E_OBJECT_NOT_FOUND: {
                    this.logger.debug("Machine %s does not exists, cannot unregister", new Object[]{machine.getName()});
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        ArrayList filteredMediaToBeDeleted = Lists.newArrayList((Iterable)Iterables.transform((Iterable)mediaToBeDeleted, (Function)new DeleteChildrenOfMedium()));
        if (!filteredMediaToBeDeleted.isEmpty()) {
            try {
                IProgress deletion = machine.delete((List)filteredMediaToBeDeleted);
                deletion.waitForCompletion(Integer.valueOf(100));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "Problem in deleting the media attached to %s", new Object[]{machine.getName()});
                Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    private class DeleteChildrenOfMedium
    implements Function<IMedium, IMedium> {
        private DeleteChildrenOfMedium() {
        }

        public IMedium apply(IMedium medium) {
            Preconditions.checkNotNull((Object)medium.getChildren());
            if (medium.getDeviceType().equals((Object)DeviceType.HardDisk)) {
                for (IMedium child : medium.getChildren()) {
                    try {
                        IProgress deletion = child.deleteStorage();
                        deletion.waitForCompletion(Integer.valueOf(-1));
                    }
                    catch (Exception e) {
                        if (!e.getMessage().contains("is still attached to the following")) continue;
                        UnregisterMachineIfExistsAndForceDeleteItsMedia.this.logger.warn("Media could not be deleted. Ignoring... [Message %s]", new Object[]{e.getMessage()});
                    }
                }
            }
            return medium;
        }
    }
}

