/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.statements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.virtualbox.domain.IsoImage;
import org.jclouds.virtualbox.domain.StorageController;
import org.jclouds.virtualbox.domain.VmSpec;

public class InstallGuestAdditions
implements Statement {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final StatementList statements;

    public InstallGuestAdditions(VmSpec vmSpecification, String vboxVersion) {
        this.statements = new StatementList(this.getStatements(vmSpecification, vboxVersion));
    }

    private List<Statement> getStatements(VmSpec vmSpecification, String vboxVersion) {
        ArrayList statements = Lists.newArrayList();
        statements.add(Statements.call((String)"installModuleAssistantIfNeeded", (String[])new String[0]));
        String mountPoint = "/mnt";
        if (Iterables.tryFind(vmSpecification.getControllers(), (Predicate)new Predicate<StorageController>(){

            public boolean apply(StorageController input) {
                if (!input.getIsoImages().isEmpty()) {
                    for (IsoImage iso : input.getIsoImages()) {
                        if (!iso.getSourcePath().contains("VBoxGuestAdditions_")) continue;
                        return true;
                    }
                }
                return false;
            }
        }).isPresent()) {
            statements.add(Statements.exec((String)("mount -t iso9660 /dev/cdrom1 " + mountPoint)));
        } else {
            String vboxGuestAdditionsIso = "VBoxGuestAdditions_" + vboxVersion + ".iso";
            URI download = URI.create("http://download.virtualbox.org/virtualbox/" + vboxVersion + "/" + vboxGuestAdditionsIso);
            statements.add(Statements.call((String)"setupPublicCurl", (String[])new String[0]));
            statements.add(Statements.saveHttpResponseTo((URI)download, (String)"{tmp}{fs}", (String)vboxGuestAdditionsIso));
            statements.add(Statements.exec((String)String.format("mount -o loop {tmp}{fs}%s %s", vboxGuestAdditionsIso, mountPoint)));
        }
        statements.add(Statements.exec((String)String.format("%s%s", mountPoint, "/VBoxLinuxAdditions.run --nox11")));
        return statements;
    }

    public String render(OsFamily family) {
        if (Preconditions.checkNotNull((Object)family, (Object)"family") == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        return this.statements.render(family);
    }

    public Iterable<String> functionDependencies(OsFamily family) {
        return this.statements.functionDependencies(family);
    }
}

