/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Inject;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.virtualbox.domain.BridgedIf;
import org.jclouds.virtualbox.domain.NetworkAdapter;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;
import org.jclouds.virtualbox.domain.NetworkSpec;
import org.jclouds.virtualbox.functions.IpAddressesLoadingCache;
import org.jclouds.virtualbox.functions.RetrieveActiveBridgedInterfaces;
import org.jclouds.virtualbox.statements.EnableNetworkInterface;
import org.jclouds.virtualbox.statements.GetIPAddressFromMAC;
import org.jclouds.virtualbox.statements.ScanNetworkWithPing;
import org.jclouds.virtualbox.util.MachineNameOrIdAndNicSlot;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.HostNetworkInterfaceType;
import org.virtualbox_4_2.IDHCPServer;
import org.virtualbox_4_2.IHostNetworkInterface;
import org.virtualbox_4_2.INetworkAdapter;
import org.virtualbox_4_2.NetworkAttachmentType;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class NetworkUtils {
    public static final int MASTER_PORT = 2222;
    private static final String VIRTUALBOX_HOST_GATEWAY = "10.0.2.15";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<VirtualBoxManager> manager;
    private final MachineUtils machineUtils;
    private final Supplier<NodeMetadata> host;
    private final Supplier<URI> providerSupplier;
    private final IpAddressesLoadingCache ipAddressesLoadingCache;
    private final RunScriptOnNode.Factory scriptRunnerFactory;
    private final Supplier<NodeMetadata> hostSupplier;

    @Inject
    public NetworkUtils(Supplier<VirtualBoxManager> manager, MachineUtils machineUtils, Supplier<NodeMetadata> host, @Provider Supplier<URI> providerSupplier, IpAddressesLoadingCache ipAddressesLoadingCache, Supplier<NodeMetadata> hostSupplier, RunScriptOnNode.Factory scriptRunnerFactory) {
        this.manager = manager;
        this.machineUtils = machineUtils;
        this.host = (Supplier)Preconditions.checkNotNull(host, (Object)"host can't be null");
        this.providerSupplier = (Supplier)Preconditions.checkNotNull(providerSupplier, (Object)"endpoint to virtualbox web server can't be null");
        this.ipAddressesLoadingCache = ipAddressesLoadingCache;
        this.scriptRunnerFactory = scriptRunnerFactory;
        this.hostSupplier = hostSupplier;
    }

    public NetworkSpec createNetworkSpecWhenVboxIsLocalhost() {
        NetworkAdapter natAdapter = NetworkAdapter.builder().networkAttachmentType(NetworkAttachmentType.NAT).build();
        NetworkInterfaceCard natIfaceCard = NetworkInterfaceCard.builder().addNetworkAdapter(natAdapter).slot(1L).build();
        NetworkAdapter hostOnlyAdapter = NetworkAdapter.builder().networkAttachmentType(NetworkAttachmentType.HostOnly).build();
        String hostOnlyIfName = this.getHostOnlyIfOrCreate();
        NetworkInterfaceCard hostOnlyIfaceCard = NetworkInterfaceCard.builder().addNetworkAdapter(hostOnlyAdapter).addHostInterfaceName(hostOnlyIfName).slot(0L).build();
        return this.createNetworkSpecForHostOnlyNATNICs(natIfaceCard, hostOnlyIfaceCard);
    }

    public NetworkInterfaceCard createHostOnlyNIC(long port) {
        NetworkAdapter hostOnlyAdapter = NetworkAdapter.builder().networkAttachmentType(NetworkAttachmentType.HostOnly).build();
        String hostOnlyIfName = this.getHostOnlyIfOrCreate();
        return NetworkInterfaceCard.builder().addNetworkAdapter(hostOnlyAdapter).addHostInterfaceName(hostOnlyIfName).slot(port).build();
    }

    public boolean enableNetworkInterface(NodeMetadata nodeMetadata, NetworkInterfaceCard networkInterfaceCard) {
        ListenableFuture<ExecResponse> execEnableNetworkInterface = this.machineUtils.runScriptOnNode(nodeMetadata, new EnableNetworkInterface(networkInterfaceCard), RunScriptOptions.NONE);
        ExecResponse execEnableNetworkInterfaceResponse = (ExecResponse)Futures.getUnchecked(execEnableNetworkInterface);
        return execEnableNetworkInterfaceResponse.getExitStatus() == 0;
    }

    private NetworkSpec createNetworkSpecForHostOnlyNATNICs(NetworkInterfaceCard natIfaceCard, NetworkInterfaceCard hostOnlyIfaceCard) {
        return NetworkSpec.builder().addNIC(hostOnlyIfaceCard).addNIC(natIfaceCard).build();
    }

    public String getHostOnlyIfOrCreate() {
        IHostNetworkInterface availableHostInterfaceIf = this.returnExistingHostNetworkInterfaceWithDHCPenabledOrNull(((VirtualBoxManager)this.manager.get()).getVBox().getHost().getNetworkInterfaces());
        if (availableHostInterfaceIf == null) {
            String hostOnlyIfName = this.createHostOnlyIf();
            this.assignDHCPtoHostOnlyInterface(hostOnlyIfName);
            return hostOnlyIfName;
        }
        return availableHostInterfaceIf.getName();
    }

    private void assignDHCPtoHostOnlyInterface(final String hostOnlyIfName) {
        List availableNetworkInterfaces = ((VirtualBoxManager)this.manager.get()).getVBox().getHost().getNetworkInterfaces();
        IHostNetworkInterface iHostNetworkInterfaceWithHostOnlyIfName = (IHostNetworkInterface)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)availableNetworkInterfaces, (Predicate)new Predicate<IHostNetworkInterface>(){

            public boolean apply(IHostNetworkInterface iHostNetworkInterface) {
                return iHostNetworkInterface.getName().equals(hostOnlyIfName);
            }
        }));
        String hostOnlyIfIpAddress = iHostNetworkInterfaceWithHostOnlyIfName.getIPAddress();
        String dhcpIpAddress = hostOnlyIfIpAddress.substring(0, hostOnlyIfIpAddress.lastIndexOf(".")) + ".254";
        String dhcpNetmask = "255.255.255.0";
        String dhcpLowerIp = hostOnlyIfIpAddress.substring(0, hostOnlyIfIpAddress.lastIndexOf(".")) + ".2";
        String dhcpUpperIp = hostOnlyIfIpAddress.substring(0, hostOnlyIfIpAddress.lastIndexOf(".")) + ".253";
        NodeMetadata hostNodeMetadata = this.getHostNodeMetadata();
        ExecResponse response = this.scriptRunnerFactory.create(hostNodeMetadata, Statements.exec((String)String.format("VBoxManage dhcpserver add --ifname %s --ip %s --netmask %s --lowerip %s --upperip %s --enable", hostOnlyIfName, dhcpIpAddress, dhcpNetmask, dhcpLowerIp, dhcpUpperIp)), RunScriptOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false)).init().call();
        Preconditions.checkState((response.getExitStatus() == 0 ? 1 : 0) != 0);
    }

    private String createHostOnlyIf() {
        NodeMetadata hostNodeMetadata = this.getHostNodeMetadata();
        ExecResponse createHostOnlyResponse = this.scriptRunnerFactory.create(hostNodeMetadata, Statements.exec((String)"VBoxManage hostonlyif create"), RunScriptOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false)).init().call();
        String output = createHostOnlyResponse.getOutput();
        Preconditions.checkState((createHostOnlyResponse.getExitStatus() == 0 ? 1 : 0) != 0, (Object)"cannot create hostonly interface ");
        Preconditions.checkState((boolean)output.contains("'"), (Object)"cannot create hostonly interface");
        return output.substring(output.indexOf("'") + 1, output.lastIndexOf("'"));
    }

    private NodeMetadata getHostNodeMetadata() {
        return NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)((NodeMetadata)this.host.get())).publicAddresses((Iterable)ImmutableList.of((Object)((URI)this.providerSupplier.get()).getHost())).build();
    }

    private IHostNetworkInterface returnExistingHostNetworkInterfaceWithDHCPenabledOrNull(Iterable<IHostNetworkInterface> availableNetworkInterfaces) {
        Preconditions.checkNotNull(availableNetworkInterfaces);
        return (IHostNetworkInterface)Iterables.getFirst(this.filterAvailableNetworkInterfaceByHostOnlyAndDHCPenabled(availableNetworkInterfaces), null);
    }

    private Iterable<IHostNetworkInterface> filterAvailableNetworkInterfaceByHostOnlyAndDHCPenabled(Iterable<IHostNetworkInterface> availableNetworkInterfaces) {
        return Iterables.filter(availableNetworkInterfaces, (Predicate)new Predicate<IHostNetworkInterface>(){

            public boolean apply(IHostNetworkInterface iHostNetworkInterface) {
                boolean match = false;
                List availableDHCPservers = ((VirtualBoxManager)NetworkUtils.this.manager.get()).getVBox().getDHCPServers();
                for (IDHCPServer idhcpServer : availableDHCPservers) {
                    if (!idhcpServer.getEnabled().booleanValue() || !idhcpServer.getNetworkName().equals(iHostNetworkInterface.getNetworkName())) continue;
                    match = true;
                }
                return iHostNetworkInterface.getInterfaceType().equals((Object)HostNetworkInterfaceType.HostOnly) && match;
            }
        });
    }

    public String getValidHostOnlyIpFromVm(String machineNameOrId) {
        int count = 0;
        String ipAddress = "";
        for (long nicSlot = 0L; nicSlot < 4L && ipAddress.isEmpty(); ++nicSlot) {
            MachineNameOrIdAndNicSlot machineNameOrIdAndNicSlot = MachineNameOrIdAndNicSlot.fromParts(machineNameOrId, nicSlot);
            while (count < 10 && ipAddress.isEmpty()) {
                Uninterruptibles.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
                ipAddress = this.getIpAddressFromNicSlot(machineNameOrIdAndNicSlot);
                if (!this.isValidIpForHostOnly(ipAddress)) {
                    this.ipAddressesLoadingCache.invalidate(machineNameOrIdAndNicSlot);
                    ipAddress = "";
                }
                ++count;
            }
        }
        return (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)ipAddress), (Object)String.format("Cannot find a valid IP address for the %s's HostOnly NIC", machineNameOrId));
    }

    public String getIpAddressFromNicSlot(String machineNameOrId, long nicSlot) {
        MachineNameOrIdAndNicSlot machineNameOrIdAndNicSlot = MachineNameOrIdAndNicSlot.fromParts(machineNameOrId, nicSlot);
        return this.getIpAddressFromNicSlot(machineNameOrIdAndNicSlot);
    }

    public String getIpAddressFromNicSlot(MachineNameOrIdAndNicSlot machineNameOrIdAndNicSlot) {
        try {
            return this.ipAddressesLoadingCache.get(machineNameOrIdAndNicSlot);
        }
        catch (ExecutionException e) {
            this.logger.error("Problem in using the ipAddressCache", new Object[]{e.getCause()});
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean isValidIpForHostOnly(String ip) {
        return !ip.isEmpty() && NetworkUtils.isIpv4(ip) && !NetworkUtils.ipBelongsToNatRange(ip) && !NetworkUtils.ipEqualsToNatGateway(ip);
    }

    public static boolean isIpv4(String s) {
        String IP_V4_ADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
        Pattern pattern = Pattern.compile(IP_V4_ADDRESS_PATTERN);
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    private static boolean ipEqualsToNatGateway(String ip) {
        return ip.equals(VIRTUALBOX_HOST_GATEWAY);
    }

    private static boolean ipBelongsToNatRange(String ip) {
        return ip.startsWith("10.0.3");
    }

    protected String getIpAddressFromBridgedNIC(INetworkAdapter networkAdapter) {
        List<BridgedIf> activeBridgedInterfaces = new RetrieveActiveBridgedInterfaces(this.scriptRunnerFactory).apply((NodeMetadata)this.hostSupplier.get());
        BridgedIf activeBridgedIf = (BridgedIf)Preconditions.checkNotNull((Object)Iterables.get(activeBridgedInterfaces, (int)0), (Object)"activeBridgedInterfaces");
        String network = activeBridgedIf.getIpAddress();
        RunScriptOnNode ipScanRunScript = this.scriptRunnerFactory.create((NodeMetadata)this.hostSupplier.get(), (Statement)new ScanNetworkWithPing(network), RunScriptOptions.NONE);
        ExecResponse execResponse = ipScanRunScript.init().call();
        Preconditions.checkState((execResponse.getExitStatus() == 0 ? 1 : 0) != 0);
        RunScriptOnNode getIpFromMACAddressRunScript = this.scriptRunnerFactory.create((NodeMetadata)this.hostSupplier.get(), (Statement)new GetIPAddressFromMAC(networkAdapter.getMACAddress()), RunScriptOptions.NONE);
        ExecResponse ipExecResponse = getIpFromMACAddressRunScript.init().call();
        Preconditions.checkState((ipExecResponse.getExitStatus() == 0 ? 1 : 0) != 0);
        return (String)Preconditions.checkNotNull((Object)ipExecResponse.getOutput(), (Object)"ipAddress");
    }
}

