/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.virtualbox.config.HardcodeLocalhostAsNodeMetadataSupplier;
import org.jclouds.virtualbox.config.VirtualBoxComputeServiceContextModule;
import org.jclouds.virtualbox.config.VirtualBoxConstants;

public class VirtualBoxApiMetadata
extends BaseApiMetadata {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public VirtualBoxApiMetadata() {
        this(new Builder());
    }

    protected VirtualBoxApiMetadata(Builder builder) {
        super((BaseApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseApiMetadata.defaultProperties();
        String workingDir = System.getProperty("test.virtualbox.workingDir", VirtualBoxConstants.VIRTUALBOX_DEFAULT_DIR);
        properties.put("jclouds.virtualbox.workingdir", workingDir);
        String ram = System.getProperty("jclouds.virtualbox.guest.memory", "512");
        properties.put("jclouds.virtualbox.guest.memory", ram);
        String yamlDescriptor = System.getProperty("test.virtualbox.image.descriptor.yaml", "jclouds.virtualbox.workingdir" + File.separator + "images.yaml");
        properties.put("jclouds.virtualbox.image.descriptor.yaml", yamlDescriptor);
        properties.put("jclouds.virtualbox.preconfigurationurl", "http://10.0.2.2:23232");
        properties.setProperty("jclouds.template", "osFamily=UBUNTU,osVersionMatches=12.04.1,os64Bit=true,osArchMatches=amd64");
        return properties;
    }

    public static class Builder
    extends BaseApiMetadata.Builder<Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("virtualbox")).name("VirtualBox API")).identityName("User")).credentialName("Password")).documentation(URI.create("https://www.virtualbox.org/sdkref/index.html"))).defaultIdentity(System.getProperty("user.name"))).defaultCredential("CHANGE_ME")).defaultEndpoint("http://localhost:18083/")).documentation(URI.create("https://github.com/jclouds/jclouds/tree/master/labs/virtualbox"))).version("4.2.8")).buildVersion("4.2.8")).defaultProperties(VirtualBoxApiMetadata.defaultProperties())).view(ComputeServiceContext.class)).defaultModules((Set)ImmutableSet.of(HardcodeLocalhostAsNodeMetadataSupplier.class, VirtualBoxComputeServiceContextModule.class));
        }

        public VirtualBoxApiMetadata build() {
            return new VirtualBoxApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

