/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.compute;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.jclouds.byon.Node;
import org.jclouds.compute.domain.OsFamily;
import org.virtualbox_4_2.IGuestOSType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.VirtualBoxManager;

public class LoadMachineFromVirtualBox
extends CacheLoader<String, Node> {
    private VirtualBoxManager manager;
    private Function<IMachine, String> iMachineToIpAddress;

    @Inject
    public LoadMachineFromVirtualBox(VirtualBoxManager manager, Function<IMachine, String> iMachineToIpAddress) {
        this.manager = manager;
        this.iMachineToIpAddress = iMachineToIpAddress;
    }

    public Node load(String id) throws Exception {
        if (id.equals("host")) {
            Node hostNode = Node.builder().id("host").name("host installing virtualbox").hostname("localhost").osFamily(OsFamily.LINUX.toString()).osDescription(System.getProperty("os.name")).osVersion(System.getProperty("os.version")).group("ssh").username(System.getProperty("user.name")).credentialUrl(LoadMachineFromVirtualBox.privateKeyFile()).build();
            return hostNode;
        }
        IMachine machine = this.manager.getVBox().findMachine(id);
        String ipAddress = (String)this.iMachineToIpAddress.apply((Object)machine);
        String osTypeId = machine.getOSTypeId();
        IGuestOSType guestOSType = this.manager.getVBox().getGuestOSType(osTypeId);
        Node node = Node.builder().id(machine.getId()).name(machine.getName()).description(machine.getDescription()).loginPort(22).group(System.getProperty("jclouds.virtualbox.machinegroup")).username(System.getProperty("jclouds.virtualbox.username")).credential(System.getProperty("jclouds.virtualbox.credential")).sudoPassword(System.getProperty("jclouds.virtualbox.credential")).locationId(System.getProperty("jclouds.virtualbox.location")).os64Bit(guestOSType.getIs64Bit().booleanValue()).osArch(guestOSType.getDescription()).osFamily(guestOSType.getFamilyDescription()).osVersion(guestOSType.getId()).osDescription(guestOSType.getDescription()).hostname(ipAddress).build();
        return node;
    }

    private static URI privateKeyFile() {
        try {
            return new URI("file://" + System.getProperty("user.home") + "/.ssh/id_rsa");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

