/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.domain.Master;
import org.jclouds.virtualbox.domain.NodeSpec;
import org.jclouds.virtualbox.domain.YamlImage;
import org.jclouds.virtualbox.functions.admin.UnregisterMachineIfExistsAndForceDeleteItsMedia;
import org.jclouds.virtualbox.util.MachineController;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISession;
import org.virtualbox_4_2.MachineState;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class VirtualBoxComputeServiceAdapter
implements ComputeServiceAdapter<IMachine, Hardware, Image, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<VirtualBoxManager> manager;
    private final Map<Image, YamlImage> imagesToYamlImages;
    private final LoadingCache<Image, Master> mastersLoader;
    private final Function<NodeSpec, ComputeServiceAdapter.NodeAndInitialCredentials<IMachine>> cloneCreator;
    private final Function<IMachine, Image> imachineToImage;
    private final MachineController machineController;

    @Inject
    public VirtualBoxComputeServiceAdapter(Supplier<VirtualBoxManager> manager, Supplier<Map<Image, YamlImage>> imagesMapper, LoadingCache<Image, Master> mastersLoader, Function<NodeSpec, ComputeServiceAdapter.NodeAndInitialCredentials<IMachine>> cloneCreator, Function<IMachine, Image> imachineToImage, MachineController machineController) {
        this.manager = (Supplier)Preconditions.checkNotNull(manager, (Object)"virtualbox manager can't be null");
        this.imagesToYamlImages = (Map)imagesMapper.get();
        this.mastersLoader = mastersLoader;
        this.cloneCreator = cloneCreator;
        this.imachineToImage = imachineToImage;
        this.machineController = machineController;
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<IMachine> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        try {
            Preconditions.checkState((!tag.contains("-0x0-") ? 1 : 0) != 0, (Object)"tag names cannot contain \"-0x0-\"");
            Preconditions.checkState((!name.contains("-0x0-") ? 1 : 0) != 0, (Object)"node names cannot contain \"-0x0-\"");
            Master master = (Master)this.mastersLoader.get((Object)template.getImage());
            Preconditions.checkState((master != null ? 1 : 0) != 0, (Object)("could not find a master for image: " + template.getImage()));
            NodeSpec nodeSpec = NodeSpec.builder().master(master).name(name).tag(tag).template(template).build();
            return (ComputeServiceAdapter.NodeAndInitialCredentials)this.cloneCreator.apply((Object)nodeSpec);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Iterable<IMachine> listNodes() {
        return Iterables.filter((Iterable)((VirtualBoxManager)this.manager.get()).getVBox().getMachines(), (Predicate)new Predicate<IMachine>(){

            public boolean apply(IMachine arg0) {
                return arg0.getName().startsWith("jclouds-node-0x0-");
            }
        });
    }

    public Iterable<IMachine> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<IMachine>(){

            public boolean apply(IMachine machine) {
                return Iterables.contains((Iterable)ids, (Object)machine.getId());
            }
        });
    }

    public Iterable<Hardware> listHardwareProfiles() {
        LinkedHashSet hardware = Sets.newLinkedHashSet();
        hardware.add(new HardwareBuilder().ids("t1.micro").hypervisor("VirtualBox").name("t1.micro").ram(512).build());
        hardware.add(new HardwareBuilder().ids("m1.small").hypervisor("VirtualBox").name("m1.small").ram(1024).build());
        hardware.add(new HardwareBuilder().ids("m1.medium").hypervisor("VirtualBox").name("m1.medium").ram(3840).build());
        hardware.add(new HardwareBuilder().ids("m1.large").hypervisor("VirtualBox").name("m1.large").ram(7680).build());
        return hardware;
    }

    public Iterable<Image> listImages() {
        final HashSet imagesFromYamlNames = Sets.newHashSet((Iterable)Iterables.transform(this.imagesToYamlImages.keySet(), (Function)new Function<Image, String>(){

            public String apply(Image input) {
                return "jclouds-image-0x0-" + input.getId();
            }
        }));
        HashSet imagesFromCloning = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(this.imageMachines(), (Predicate)new Predicate<IMachine>(){

            public boolean apply(IMachine input) {
                return !imagesFromYamlNames.contains(input.getName());
            }
        }), this.imachineToImage));
        return Sets.union(this.imagesToYamlImages.keySet(), (Set)imagesFromCloning);
    }

    private Iterable<IMachine> imageMachines() {
        Predicate<IMachine> imagePredicate = new Predicate<IMachine>(){

            public boolean apply(@Nullable IMachine iMachine) {
                return iMachine.getName().startsWith("jclouds-image-0x0-");
            }
        };
        Iterable imageMachines = Iterables.filter((Iterable)((VirtualBoxManager)this.manager.get()).getVBox().getMachines(), (Predicate)imagePredicate);
        return imageMachines;
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public IMachine getNode(String vmName) {
        try {
            return ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName);
        }
        catch (VBoxException e) {
            if (e.getMessage().contains("Could not find a registered machine named")) {
                return null;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Image getImage(String vmName) {
        IMachine image = this.getNode(vmName);
        if (image == null) {
            return null;
        }
        return (Image)this.imachineToImage.apply((Object)image);
    }

    public synchronized void destroyNode(String vmName) {
        IMachine machine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName);
        this.powerDownMachine(machine);
        try {
            new UnregisterMachineIfExistsAndForceDeleteItsMedia().apply(machine);
        }
        catch (Exception e) {
            this.logger.error("Machine (%s) not unregistered!", new Object[]{vmName});
        }
    }

    public void rebootNode(String vmName) {
        IMachine machine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName);
        this.powerDownMachine(machine);
        this.launchVMProcess(machine, ((VirtualBoxManager)this.manager.get()).getSessionObject());
    }

    public void resumeNode(String vmName) {
        IMachine machine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName);
        try {
            ISession machineSession = ((VirtualBoxManager)this.manager.get()).openMachineSession(machine);
            machineSession.getConsole().resume();
            machineSession.unlockMachine();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void suspendNode(String vmName) {
        IMachine machine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName);
        try {
            ISession machineSession = ((VirtualBoxManager)this.manager.get()).openMachineSession(machine);
            machineSession.getConsole().pause();
            machineSession.unlockMachine();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void launchVMProcess(IMachine machine, ISession session) {
        IProgress prog = machine.launchVMProcess(session, "gui", "");
        prog.waitForCompletion(Integer.valueOf(-1));
        session.unlockMachine();
    }

    private void powerDownMachine(IMachine machine) {
        try {
            if (machine.getState() == MachineState.PoweredOff) {
                this.logger.debug("vm was already powered down: ", new Object[]{machine.getId()});
                return;
            }
            this.logger.debug("<< powering down vm(%s)", new Object[]{machine.getName()});
            this.machineController.ensureMachineHasPowerDown(machine.getName());
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "problem in powering down vm(%s)", new Object[]{machine.getName()});
            throw Throwables.propagate((Throwable)e);
        }
    }
}

