/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.config;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;

public class HardcodeLocalhostAsNodeMetadataSupplier
extends AbstractModule {
    public static final String HOST_ID = "host";
    public static final String HOSTNAME = Strings.nullToEmpty((String)System.getenv("HOSTNAME"));

    @Provides
    @Singleton
    protected Supplier<NodeMetadata> lazySupplyHostAsNodeMetadata() {
        return new Supplier<NodeMetadata>(){

            public NodeMetadata get() {
                String privateKey = HardcodeLocalhostAsNodeMetadataSupplier.readRsaIdentity();
                return new NodeMetadataBuilder().id(HardcodeLocalhostAsNodeMetadataSupplier.HOST_ID).name("host installing virtualbox").hostname(HOSTNAME).operatingSystem(OperatingSystem.builder().family(OsFamily.LINUX).description(System.getProperty("os.name")).arch(System.getProperty("os.arch")).version(System.getProperty("os.version")).build()).status(NodeMetadata.Status.RUNNING).location(new LocationBuilder().id(HardcodeLocalhostAsNodeMetadataSupplier.HOST_ID).scope(LocationScope.HOST).description(HOSTNAME).build()).credentials(LoginCredentials.builder().user(System.getProperty("user.name")).privateKey(privateKey).build()).build();
            }
        };
    }

    static String readRsaIdentity() {
        String privateKey;
        try {
            File keyFile = new File(System.getProperty("user.home") + "/.ssh/id_rsa");
            privateKey = Files.toString((File)keyFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return privateKey;
    }

    protected void configure() {
    }
}

