/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.eclipse.jetty.server.Server;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.ssh.SshClient;
import org.jclouds.util.Predicates2;
import org.jclouds.virtualbox.compute.VirtualBoxComputeServiceAdapter;
import org.jclouds.virtualbox.compute.extensions.VirtualBoxImageExtension;
import org.jclouds.virtualbox.domain.CloneSpec;
import org.jclouds.virtualbox.domain.ExecutionType;
import org.jclouds.virtualbox.domain.IsoSpec;
import org.jclouds.virtualbox.domain.Master;
import org.jclouds.virtualbox.domain.MasterSpec;
import org.jclouds.virtualbox.domain.NodeSpec;
import org.jclouds.virtualbox.domain.YamlImage;
import org.jclouds.virtualbox.functions.CloneAndRegisterMachineFromIMachineIfNotAlreadyExists;
import org.jclouds.virtualbox.functions.CreateAndInstallVm;
import org.jclouds.virtualbox.functions.IMachineToHardware;
import org.jclouds.virtualbox.functions.IMachineToImage;
import org.jclouds.virtualbox.functions.IMachineToNodeMetadata;
import org.jclouds.virtualbox.functions.IMachineToSshClient;
import org.jclouds.virtualbox.functions.MastersLoadingCache;
import org.jclouds.virtualbox.functions.NodeCreator;
import org.jclouds.virtualbox.functions.YamlImagesFromFileConfig;
import org.jclouds.virtualbox.functions.admin.FileDownloadFromURI;
import org.jclouds.virtualbox.functions.admin.ImagesToYamlImagesFromYamlDescriptor;
import org.jclouds.virtualbox.functions.admin.PreseedCfgServer;
import org.jclouds.virtualbox.functions.admin.StartVBoxIfNotAlreadyRunning;
import org.jclouds.virtualbox.predicates.SshResponds;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.LockType;
import org.virtualbox_4_2.MachineState;
import org.virtualbox_4_2.VirtualBoxManager;

public class VirtualBoxComputeServiceContextModule
extends ComputeServiceAdapterContextModule<IMachine, Hardware, Image, Location> {
    @VisibleForTesting
    public static final Map<MachineState, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put((Object)MachineState.Running, (Object)NodeMetadata.Status.RUNNING).put((Object)MachineState.PoweredOff, (Object)NodeMetadata.Status.SUSPENDED).put((Object)MachineState.DeletingSnapshot, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.DeletingSnapshotOnline, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.DeletingSnapshotPaused, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.FaultTolerantSyncing, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.LiveSnapshotting, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.SettingUp, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.Starting, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.Stopping, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.Restoring, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.FirstOnline, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.FirstTransient, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.LastOnline, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.LastTransient, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.Teleported, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.TeleportingIn, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.TeleportingPausedVM, (Object)NodeMetadata.Status.PENDING).put((Object)MachineState.Aborted, (Object)NodeMetadata.Status.ERROR).put((Object)MachineState.Stuck, (Object)NodeMetadata.Status.ERROR).put((Object)MachineState.Null, (Object)NodeMetadata.Status.TERMINATED).build();
    @VisibleForTesting
    public static final Map<MachineState, Image.Status> toPortableImageStatus = ImmutableMap.builder().put((Object)MachineState.Running, (Object)Image.Status.PENDING).put((Object)MachineState.PoweredOff, (Object)Image.Status.AVAILABLE).put((Object)MachineState.DeletingSnapshot, (Object)Image.Status.PENDING).put((Object)MachineState.DeletingSnapshotOnline, (Object)Image.Status.PENDING).put((Object)MachineState.DeletingSnapshotPaused, (Object)Image.Status.PENDING).put((Object)MachineState.FaultTolerantSyncing, (Object)Image.Status.PENDING).put((Object)MachineState.LiveSnapshotting, (Object)Image.Status.PENDING).put((Object)MachineState.SettingUp, (Object)Image.Status.PENDING).put((Object)MachineState.Starting, (Object)Image.Status.PENDING).put((Object)MachineState.Stopping, (Object)Image.Status.PENDING).put((Object)MachineState.Restoring, (Object)Image.Status.PENDING).put((Object)MachineState.FirstOnline, (Object)Image.Status.PENDING).put((Object)MachineState.FirstTransient, (Object)Image.Status.PENDING).put((Object)MachineState.LastOnline, (Object)Image.Status.PENDING).put((Object)MachineState.LastTransient, (Object)Image.Status.PENDING).put((Object)MachineState.Teleported, (Object)Image.Status.PENDING).put((Object)MachineState.TeleportingIn, (Object)Image.Status.PENDING).put((Object)MachineState.TeleportingPausedVM, (Object)Image.Status.PENDING).put((Object)MachineState.Aborted, (Object)Image.Status.ERROR).put((Object)MachineState.Stuck, (Object)Image.Status.ERROR).put((Object)MachineState.Null, (Object)Image.Status.DELETED).build();

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<IMachine, Hardware, Image, Location>>(){}).to(VirtualBoxComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<IMachine, NodeMetadata>>(){}).to(IMachineToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<Hardware, Hardware>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, Image>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<IMachine, Hardware>>(){}).to(IMachineToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<IMachine, Image>>(){}).to(IMachineToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<IsoSpec, URI>>(){}).to((Class)Class.class.cast(PreseedCfgServer.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<URI, File>>(){}).to((Class)Class.class.cast(FileDownloadFromURI.class));
        this.bind((TypeLiteral)new TypeLiteral<Supplier<VirtualBoxManager>>(){}).to((Class)Class.class.cast(StartVBoxIfNotAlreadyRunning.class));
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Map<Image, YamlImage>>>(){}).to((Class)Class.class.cast(ImagesToYamlImagesFromYamlDescriptor.class));
        this.bind(YamlImagesFromFileConfig.class);
        this.bind((TypeLiteral)new TypeLiteral<LoadingCache<Image, Master>>(){}).to(MastersLoadingCache.class);
        this.bind((TypeLiteral)new TypeLiteral<ImageExtension>(){}).to(VirtualBoxImageExtension.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<MasterSpec, IMachine>>(){}).to((Class)Class.class.cast(CreateAndInstallVm.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<NodeSpec, ComputeServiceAdapter.NodeAndInitialCredentials<IMachine>>>(){}).to((Class)Class.class.cast(NodeCreator.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<CloneSpec, IMachine>>(){}).to((Class)Class.class.cast(CloneAndRegisterMachineFromIMachineIfNotAlreadyExists.class));
        this.bind((TypeLiteral)new TypeLiteral<Server>(){}).to((Class)Class.class.cast(PreseedCfgServer.class)).asEagerSingleton();
        this.bind((TypeLiteral)new TypeLiteral<Function<IMachine, SshClient>>(){}).to(IMachineToSshClient.class);
        this.bind(ExecutionType.class).toInstance((Object)ExecutionType.HEADLESS);
        this.bind(LockType.class).toInstance((Object)LockType.Write);
    }

    @Provides
    @Singleton
    protected Function<Supplier<NodeMetadata>, VirtualBoxManager> provideVBox() {
        return new Function<Supplier<NodeMetadata>, VirtualBoxManager>(){

            public VirtualBoxManager apply(Supplier<NodeMetadata> nodeSupplier) {
                if (((NodeMetadata)nodeSupplier.get()).getId() != null) {
                    return VirtualBoxManager.createInstance((String)((NodeMetadata)nodeSupplier.get()).getId());
                }
                return VirtualBoxManager.createInstance((String)"");
            }

            public String toString() {
                return "createInstanceByNodeId()";
            }
        };
    }

    @Provides
    @Singleton
    protected Predicate<SshClient> sshResponds(SshResponds sshResponds, ComputeServiceConstants.Timeouts timeouts) {
        return Predicates2.retry((Predicate)sshResponds, (long)timeouts.nodeRunning, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.of((Object)i.getInstance(ImageExtension.class));
    }

    @Singleton
    @Provides
    protected Map<MachineState, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    protected Map<MachineState, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }
}

