/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.virtualbox.domain.NetworkSpec;
import org.jclouds.virtualbox.domain.VmSpec;
import org.virtualbox_4_2.IMachine;

public class CloneSpec {
    private final VmSpec vmSpec;
    private final NetworkSpec networkSpec;
    private final IMachine master;
    private final boolean isLinked;

    public static Builder builder() {
        return new Builder();
    }

    public CloneSpec(VmSpec vmSpec, NetworkSpec networkSpec, IMachine master, boolean isLinked) {
        this.vmSpec = (VmSpec)Preconditions.checkNotNull((Object)vmSpec, (Object)"vmSpec can't be null");
        this.networkSpec = (NetworkSpec)Preconditions.checkNotNull((Object)networkSpec, (Object)"networkSpec can't be null");
        this.master = (IMachine)Preconditions.checkNotNull((Object)master, (Object)"master can't be null");
        this.isLinked = isLinked;
    }

    public VmSpec getVmSpec() {
        return this.vmSpec;
    }

    public NetworkSpec getNetworkSpec() {
        return this.networkSpec;
    }

    public IMachine getMaster() {
        return this.master;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloneSpec) {
            CloneSpec other = (CloneSpec)o;
            return Objects.equal((Object)this.vmSpec, (Object)other.vmSpec) && Objects.equal((Object)this.networkSpec, (Object)other.networkSpec);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.vmSpec, this.networkSpec});
    }

    public String toString() {
        return "CloneSpec{vmSpec= " + this.vmSpec + ", networkSpec= " + this.networkSpec + '}';
    }

    public static class Builder {
        private VmSpec vmSpec;
        private NetworkSpec networkSpec;
        private IMachine master;
        private boolean isLinked;

        public Builder vm(VmSpec vmSpec) {
            this.vmSpec = vmSpec;
            return this;
        }

        public Builder network(NetworkSpec networkSpec) {
            this.networkSpec = networkSpec;
            return this;
        }

        public Builder master(IMachine master) {
            this.master = master;
            return this;
        }

        public Builder linked(boolean isLinked) {
            this.isLinked = isLinked;
            return this;
        }

        public CloneSpec build() {
            return new CloneSpec(this.vmSpec, this.networkSpec, this.master, this.isLinked);
        }
    }
}

