/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.virtualbox.domain.DeviceDetails;
import org.virtualbox_4_2.DeviceType;

public class HardDisk {
    public static final String DEFAULT_DISK_FORMAT = "vdi";
    private final String name;
    private final String diskFormat;
    private final String diskPath;
    private final DeviceDetails deviceDetails;
    private final boolean autoDelete;

    public HardDisk(DeviceDetails deviceDetails, String diskPath, String diskFormat, boolean autoDelete) {
        this.diskPath = (String)Preconditions.checkNotNull((Object)diskPath, (Object)"diskPath can't be null");
        this.diskFormat = (String)Preconditions.checkNotNull((Object)diskFormat, (Object)"diskFormat can't be null");
        this.deviceDetails = (DeviceDetails)Preconditions.checkNotNull((Object)deviceDetails, (Object)"deviceDetails can't be null");
        this.name = diskPath.substring(diskPath.lastIndexOf("/") + 1);
        this.autoDelete = autoDelete;
    }

    public String getDiskPath() {
        return this.diskPath;
    }

    public String getDiskFormat() {
        return this.diskFormat;
    }

    public DeviceDetails getDeviceDetails() {
        return this.deviceDetails;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardDisk) {
            HardDisk hardDisk = (HardDisk)o;
            return Objects.equal((Object)this.deviceDetails, (Object)hardDisk.deviceDetails) && Objects.equal((Object)this.diskFormat, (Object)hardDisk.diskFormat) && Objects.equal((Object)this.diskPath, (Object)hardDisk.diskPath) && Objects.equal((Object)this.name, (Object)hardDisk.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.diskPath, this.diskFormat, this.deviceDetails, this.name});
    }

    public String toString() {
        return "HardDisk{diskFormat='" + this.diskFormat + '\'' + ", diskPath='" + this.diskPath + '\'' + ", deviceDetails=" + this.deviceDetails + ", name=" + this.name + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String diskFormat = "vdi";
        private String diskPath;
        private int controllerPort;
        private int deviceSlot;
        private DeviceType deviceType = DeviceType.HardDisk;
        private boolean autoDelete = false;

        public Builder diskFormat(String diskFormat) {
            this.diskFormat = diskFormat;
            return this;
        }

        public Builder diskpath(String diskPath) {
            this.diskPath = diskPath;
            return this;
        }

        public Builder controllerPort(int controllerPort) {
            this.controllerPort = controllerPort;
            return this;
        }

        public Builder deviceSlot(int deviceSlot) {
            this.deviceSlot = deviceSlot;
            return this;
        }

        public Builder autoDelete(boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public HardDisk build() {
            Preconditions.checkNotNull((Object)this.diskPath);
            Preconditions.checkNotNull((Object)this.controllerPort);
            Preconditions.checkNotNull((Object)this.deviceSlot);
            return new HardDisk(new DeviceDetails(this.controllerPort, this.deviceSlot, this.deviceType), this.diskPath, this.diskFormat, this.autoDelete);
        }
    }
}

